/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.extend;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyService;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobHandler;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperTypeLoadAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public class LongTextType
extends ComplexWrapperType {
    private static final long serialVersionUID = -4263828374127798455L;
    private static final int hash = 26;
    private static final int META_PART_LENGTH = 21;
    public static final String LOB_STORE_NAME = "longTextStore";
    public static final String LOB_NAME = "_LongText";
    private PropertyType actualType = new StringType();

    @Override
    public int hashCode() {
        return 26;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public boolean isCompatibleTo(PropertyType another) {
        return this.equals(another);
    }

    @Override
    public LongTextProperty createPropertyDefinitionInstance() {
        return new LongTextProperty();
    }

    @Override
    public Object createRuntime(MetaProperty metaProperty, MetaEntity metaEntity) {
        return null;
    }

    @Override
    public LongTextType copy() {
        return new LongTextType();
    }

    @Override
    public PropertyType actualType() {
        return this.actualType;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.LONGTEXT;
    }

    @Override
    public PropertyDefinitionType getDataStoreEnumType() {
        return PropertyDefinitionType.STRING;
    }

    @Override
    public boolean isNeedPrevStoreTypeValueOnToStoreTypeValue() {
        return true;
    }

    @Override
    public Object toStoreTypeValue(Object extendTypeValue, Object prevStoreTypeValue, PropertyHandler ph, EntityHandler eh, String oid, Long version, Entity entity) {
        try {
            LongText longText;
            if (prevStoreTypeValue != null && (longText = new LongText((String)prevStoreTypeValue)).lobId != -1L) {
                LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
                lm.removeBinaryData(longText.lobId);
            }
            if (extendTypeValue != null && ((String)extendTypeValue).length() != 0) {
                LongText newVal = new LongText(-1L, (String)extendTypeValue);
                int inlineStoreMaxLength = this.inlineStoreMaxLength(eh);
                if (!newVal.isInlineStore(inlineStoreMaxLength)) {
                    LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
                    Lob bin = lm.createBinaryData(LOB_NAME, "text/plain", eh.getMetaData().getId(), ph.getId(), oid, version);
                    bin.setByte(((String)extendTypeValue).getBytes("utf-8"));
                    newVal.lobId = bin.getLobId();
                    newVal.trimOrClearText(inlineStoreMaxLength);
                }
                return newVal.toStringExpression();
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityRuntimeException(e);
        }
    }

    @Override
    public void notifyAfterDelete(Object storeTypeValue, PropertyHandler ph, EntityHandler eh, String oid, Long rbid) {
        LongText longText;
        if (storeTypeValue != null && (longText = new LongText((String)storeTypeValue)).lobId != -1L) {
            LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
            if (rbid == null) {
                lm.removeBinaryData(longText.lobId);
            } else {
                lm.markToRecycleBin(longText.lobId, rbid);
            }
        }
    }

    @Override
    public void notifyAfterPurge(EntityHandler eh, Long rbid) {
        LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
        lm.removeBinaryDataByRbid(rbid);
    }

    @Override
    public void notifyAfterRestore(EntityHandler eh, Long rbid) {
        LobHandler lm = LobHandler.getInstance(LOB_STORE_NAME);
        lm.markRestoreFromRecycleBin(rbid);
    }

    @Override
    public Class<?> extendType() {
        return String.class;
    }

    @Override
    public ComplexWrapperTypeLoadAdapter createLoadAdapter() {
        return new LongTextTypeLoadAdapter();
    }

    private int inlineStoreMaxLength(EntityHandler eh) {
        int dataStoreStringMaxLength = LongText.storeService.getDataStore().stringPropertyStoreMaxLength(eh.getMetaData().getStoreMapping());
        if (dataStoreStringMaxLength < 0) {
            return LongText.service.getLongTextInlineStoreMaxLength();
        }
        return Math.min(LongText.service.getLongTextInlineStoreMaxLength(), dataStoreStringMaxLength - 21);
    }

    @Override
    public String toString(Object value) {
        return (String)value;
    }

    @Override
    public Object fromString(String strValue) {
        return strValue;
    }

    @Override
    public ValueExpression translate(EntityField field) {
        if (LongText.service.isRemainInlineText()) {
            return new Function("SUBSTR", field, new Literal(22L));
        }
        throw new EntityRuntimeException("LongText Property can only placed main query's select clause. To use at other clause(eg:where condition...), turn on PropertyService's remainInlineText property of config file.");
    }

    private class LongTextTypeLoadAdapter
    implements ComplexWrapperTypeLoadAdapter {
        private Map<Long, Lob> currentRowValue;
        private LobHandler lobHandler;
        private EntityContext context;

        private LongTextTypeLoadAdapter() {
        }

        @Override
        public void setContext(EntityContext context) {
            this.context = context;
            this.lobHandler = LobHandler.getInstance(LongTextType.LOB_STORE_NAME);
        }

        @Override
        public void nextCalled(List<Object> values) {
            ArrayList<Long> lobedValues = new ArrayList<Long>();
            for (Object v : values) {
                LongText lt = new LongText((String)v);
                if (lt.lobId == -1L) continue;
                lobedValues.add(lt.lobId);
            }
            if (lobedValues.size() > 0) {
                long[] lobIdList = new long[lobedValues.size()];
                for (int i = 0; i < lobedValues.size(); ++i) {
                    lobIdList[i] = (Long)lobedValues.get(i);
                }
                Lob[] res = this.lobHandler.getBinaryReference(lobIdList, this.context);
                if (res != null) {
                    this.currentRowValue = new HashMap<Long, Lob>();
                    for (Lob bin : res) {
                        this.currentRowValue.put(bin.getLobId(), bin);
                    }
                }
            }
        }

        @Override
        public void close() {
        }

        @Override
        public Object toComplexWrapperTypeValue(Object value) {
            if (value == null) {
                return null;
            }
            LongText lt = new LongText((String)value);
            if (lt.lobId == -1L) {
                return lt.text;
            }
            if (this.currentRowValue == null) {
                return null;
            }
            Lob bin = this.currentRowValue.get(lt.lobId);
            if (bin == null) {
                return null;
            }
            try {
                return new String(bin.getByte(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new EntityRuntimeException(e);
            }
        }

        @Override
        public Object[] newComplexWrapperTypeArray(int size) {
            return new String[size];
        }
    }

    public static class LongText {
        private static final char[] SPACE = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        private static PropertyService service = ServiceRegistry.getRegistry().getService(PropertyService.class);
        private static StoreService storeService = ServiceRegistry.getRegistry().getService(StoreService.class);
        private long lobId;
        private String text;

        public static void appendLongTextFromStringExpression(StringBuilder sb) {
            sb.append("L=").append(SPACE, 0, 14).append("-1");
            sb.append(",T=");
        }

        private LongText() {
        }

        private LongText(long lobId, String text) {
            this.lobId = lobId;
            this.text = text;
        }

        private LongText(String stringExpression) {
            if (stringExpression != null && stringExpression.startsWith("L=")) {
                this.lobId = Long.parseLong(stringExpression.substring(2, 18).trim());
                if (stringExpression.length() > 21) {
                    this.text = stringExpression.substring(21);
                }
            } else {
                this.lobId = -1L;
            }
        }

        private String toStringExpression() {
            StringBuilder sb = new StringBuilder();
            String lobIdStr = Long.toString(this.lobId);
            sb.append("L=").append(SPACE, 0, 16 - lobIdStr.length()).append(lobIdStr);
            sb.append(",T=");
            if (this.text != null) {
                sb.append(this.text);
            }
            return sb.toString();
        }

        private boolean isInlineStore(int inlineStoreMaxLength) {
            if (this.text == null) {
                return true;
            }
            return this.text.length() <= inlineStoreMaxLength;
        }

        private void trimOrClearText(int inlineStoreMaxLength) {
            if (service.isRemainInlineText()) {
                if (this.text != null && this.text.length() > inlineStoreMaxLength) {
                    this.text = this.text.substring(0, inlineStoreMaxLength);
                }
            } else {
                this.text = null;
            }
        }
    }
}

