/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.From;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.FromSyntax;
import org.iplass.mtp.impl.query.GroupBySyntax;
import org.iplass.mtp.impl.query.HavingSyntax;
import org.iplass.mtp.impl.query.LimitSyntax;
import org.iplass.mtp.impl.query.OrderBySyntax;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.ReferSyntax;
import org.iplass.mtp.impl.query.SelectSyntax;
import org.iplass.mtp.impl.query.WhereSyntax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySyntax
implements Syntax<Query>,
QueryConstants {
    private static Logger logger = LoggerFactory.getLogger(QuerySyntax.class);
    private SelectSyntax select;
    private FromSyntax from;
    private ReferSyntax refer;
    private WhereSyntax where;
    private GroupBySyntax groupBy;
    private HavingSyntax having;
    private OrderBySyntax orderBy;
    private LimitSyntax limit;

    @Override
    public void init(SyntaxContext context) {
        this.select = context.getSyntax(SelectSyntax.class);
        this.from = context.getSyntax(FromSyntax.class);
        this.refer = context.getSyntax(ReferSyntax.class);
        this.where = context.getSyntax(WhereSyntax.class);
        this.groupBy = context.getSyntax(GroupBySyntax.class);
        this.having = context.getSyntax(HavingSyntax.class);
        this.orderBy = context.getSyntax(OrderBySyntax.class);
        this.limit = context.getSyntax(LimitSyntax.class);
    }

    @Override
    public Query parse(ParseContext str) throws ParseException {
        long start = 0L;
        if (logger.isTraceEnabled()) {
            start = System.nanoTime();
        }
        Query q = new Query();
        Select s = this.select.parse(str);
        q.setSelect(s);
        From f = this.from.parse(str);
        q.setFrom(f);
        ArrayList<Refer> referList = null;
        while (str.equalsNextToken("REFER", ParseContext.TOKEN_DELIMITERS)) {
            if (referList == null) {
                referList = new ArrayList<Refer>();
            }
            Refer r = this.refer.parse(str);
            referList.add(r);
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (referList != null) {
            q.setRefer(referList);
        }
        if (str.equalsNextToken("WHERE", ParseContext.TOKEN_DELIMITERS)) {
            Where w = this.where.parse(str);
            q.setWhere(w);
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.isEnd() && str.equalsNextToken("GROUP", ParseContext.TOKEN_DELIMITERS)) {
            q.setGroupBy(this.groupBy.parse(str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.isEnd() && str.equalsNextToken("HAVING", ParseContext.TOKEN_DELIMITERS)) {
            q.setHaving(this.having.parse(str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.isEnd() && str.equalsNextToken("ORDER", ParseContext.TOKEN_DELIMITERS)) {
            q.setOrderBy(this.orderBy.parse(str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.isEnd() && str.equalsNextToken("LIMIT", ParseContext.TOKEN_DELIMITERS)) {
            q.setLimit(this.limit.parse(str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.isEnd() && str.equalsNextToken("VERSIONED", ParseContext.TOKEN_DELIMITERS)) {
            q.setVersioned(true);
            str.consumeChars("VERSIONED".length());
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.isEnd() && str.equalsNextToken("LOCALIZED", ParseContext.TOKEN_DELIMITERS)) {
            q.setLocalized(true);
            str.consumeChars("LOCALIZED".length());
        }
        if (logger.isTraceEnabled()) {
            long time = System.nanoTime() - start;
            logger.trace("parse time:{}ms query:{}", (Object)((double)time / 1000000.0), (Object)q);
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        return q;
    }
}

