/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class SortSpecSyntax
implements Syntax<SortSpec>,
QueryConstants {
    private PolynomialSyntax polynomial;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SortSpec parse(ParseContext str) throws ParseException {
        ValueExpression ve = this.polynomial.parse(str);
        SortSpec sortSpec = new SortSpec();
        sortSpec.setSortKey(ve);
        int current = str.getCurrentIndex();
        String token = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if ("ASC".equalsIgnoreCase(token)) {
            sortSpec.setType(SortSpec.SortType.ASC);
        } else if ("DESC".equalsIgnoreCase(token)) {
            sortSpec.setType(SortSpec.SortType.DESC);
        } else {
            str.setCurrentIndex(current);
        }
        current = str.getCurrentIndex();
        str.consumeChars(ParseContext.WHITE_SPACES);
        token = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if (!"NULLS".equalsIgnoreCase(token)) {
            str.setCurrentIndex(current);
            return sortSpec;
        }
        current = str.getCurrentIndex();
        if (!str.consumeChars(ParseContext.WHITE_SPACES)) {
            str.setCurrentIndex(current);
            throw new ParseException(new EvalError("FIRST or LAST expected.", this, str));
        }
        token = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if ("FIRST".equalsIgnoreCase(token)) {
            sortSpec.setNullOrderingSpec(SortSpec.NullOrderingSpec.FIRST);
            return sortSpec;
        }
        if ("LAST".equalsIgnoreCase(token)) {
            sortSpec.setNullOrderingSpec(SortSpec.NullOrderingSpec.LAST);
            return sortSpec;
        }
        str.setCurrentIndex(current);
        throw new ParseException(new EvalError("FIRST or LAST expected.", this, str));
    }

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }
}

