/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.condition.predicate;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.SubQuerySyntax;
import org.iplass.mtp.impl.query.value.RowValueListSyntax;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class InSyntax
implements Syntax<In>,
QueryConstants {
    private PolynomialSyntax polynomial;
    private SubQuerySyntax subQuerySyntax;
    private RowValueListSyntax rowValueList;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
        this.subQuerySyntax = context.getSyntax(SubQuerySyntax.class);
        this.rowValueList = context.getSyntax(RowValueListSyntax.class);
    }

    @Override
    public In parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("IN", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("in expected.", this, str));
        }
        str.consumeChars("IN".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        In in = new In();
        int currentPos = str.getCurrentIndex();
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars("(".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.equalsNextToken("SELECT", ParseContext.TOKEN_DELIMITERS)) {
            str.setCurrentIndex(currentPos);
            SubQuery subQuery = this.subQuerySyntax.parse(str);
            in.setSubQuery(subQuery);
            return in;
        }
        if (str.startsWith("(")) {
            currentPos = str.getCurrentIndex();
            try {
                ArrayList<ValueExpression> values = new ArrayList<ValueExpression>();
                boolean isFirst = true;
                while (isFirst || !isFirst && str.startsWith(",")) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        str.consumeChars(",".length());
                        str.consumeChars(ParseContext.WHITE_SPACES);
                    }
                    values.add(this.rowValueList.parse(str));
                }
                if (!str.startsWith(")")) {
                    throw new ParseException(new EvalError(") expected.", this, str));
                }
                str.consumeChars(")".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
                in.setValue(values);
                return in;
            }
            catch (ParseException pe) {
                str.setCurrentIndex(currentPos);
            }
        }
        ArrayList<ValueExpression> values = new ArrayList<ValueExpression>();
        boolean isFirst = true;
        while (isFirst || !isFirst && str.startsWith(",")) {
            if (isFirst) {
                isFirst = false;
            } else {
                str.consumeChars(",".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            values.add(this.polynomial.parse(str));
        }
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(")".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        in.setValue(values);
        return in;
    }
}

