/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.hint;

import java.util.List;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintComment;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.QueryServiceHolder;
import org.iplass.mtp.impl.query.hint.HintSyntax;

public class HintCommentSyntax
implements Syntax<HintComment>,
QueryConstants {
    private HintSyntax hint;

    @Override
    public HintComment parse(ParseContext str) throws ParseException {
        if (!str.startsWith("/*+")) {
            throw new ParseException(new EvalError("/*+ expected.", this, str));
        }
        str.consumeChars("/*+".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        HintComment hc = new HintComment();
        while (!str.startsWith("*/")) {
            int currentIndex = str.getCurrentIndex();
            try {
                hc.add(this.hint.parse(str));
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            catch (ParseException e) {
                str.setCurrentIndex(currentIndex);
                if (this.externalHint(str, hc)) continue;
                throw e;
            }
        }
        str.consumeChars("*/".length());
        return hc;
    }

    private boolean externalHint(ParseContext str, HintComment hc) throws ParseException {
        if (!str.equalsNextToken("@HINT", ParseContext.TOKEN_DELIMITERS)) {
            return false;
        }
        str.consumeChars("@HINT".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.popChar() != '(') {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        String key = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if (key == null) {
            throw new ParseException(new EvalError("External Hint key expected.", this, str));
        }
        List<Hint> ehs = QueryServiceHolder.getInstance().getExternalHint(key);
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.popChar() != ')') {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        for (Hint h : ehs) {
            hc.add(h);
        }
        return true;
    }

    @Override
    public void init(SyntaxContext context) {
        this.hint = context.getSyntax(HintSyntax.class);
    }
}

