/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.hint;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.hint.BindHint;
import org.iplass.mtp.entity.query.hint.CacheHint;
import org.iplass.mtp.entity.query.hint.FetchSizeHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.IndexHint;
import org.iplass.mtp.entity.query.hint.NativeHint;
import org.iplass.mtp.entity.query.hint.NoBindHint;
import org.iplass.mtp.entity.query.hint.NoIndexHint;
import org.iplass.mtp.entity.query.hint.ReadOnlyHint;
import org.iplass.mtp.entity.query.hint.SuppressWarningsHint;
import org.iplass.mtp.entity.query.hint.TimeoutHint;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;

public class HintSyntax
implements Syntax<Hint>,
QueryConstants {
    private static char[] RIGHT_PAREN_DELS = new char[]{')'};

    @Override
    public void init(SyntaxContext context) {
    }

    private List<String> parseList(ParseContext str) throws ParseException {
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.peekChar() != '(') {
            return null;
        }
        str.consumeChars(1);
        str.consumeChars(ParseContext.WHITE_SPACES);
        ArrayList<String> list = new ArrayList<String>();
        boolean isFirst = true;
        while (!str.startsWith(")") && !str.isEnd()) {
            if (isFirst) {
                isFirst = false;
            } else {
                if (!str.consumeChars(",".length())) {
                    throw new ParseException(new EvalError(", expected.", this, str));
                }
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            String val = str.nextToken(ParseContext.TOKEN_DELIMITERS);
            if (val == null) {
                throw new ParseException(new EvalError("hint's argument expected.", this, str));
            }
            list.add(val);
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (str.popChar() != ')') {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        return list;
    }

    @Override
    public Hint parse(ParseContext str) throws ParseException {
        int currentIndex = str.getCurrentIndex();
        String token = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if (token == null) {
            throw new ParseException(new EvalError("hint clause expected.", this, str));
        }
        switch (token = token.toUpperCase()) {
            case "INDEX": {
                IndexHint ih = new IndexHint();
                ih.setPropertyNameList(this.parseList(str));
                return ih;
            }
            case "NO_INDEX": {
                NoIndexHint nih = new NoIndexHint();
                nih.setPropertyNameList(this.parseList(str));
                return nih;
            }
            case "NATIVE": {
                String nhExp;
                NativeHint nh = new NativeHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.popChar() != '(') {
                    throw new ParseException(new EvalError("( expected.", this, str));
                }
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.peekChar() != '\'') {
                    String tableName = str.nextToken(ParseContext.TOKEN_DELIMITERS);
                    if (tableName == null) {
                        throw new ParseException(new EvalError("NativeHint table argument expected.", this, str));
                    }
                    str.consumeChars(ParseContext.WHITE_SPACES);
                    if (str.popChar() != ',') {
                        throw new ParseException(new EvalError(", expected.", this, str));
                    }
                    str.consumeChars(ParseContext.WHITE_SPACES);
                    nh.setTable(tableName);
                }
                if ((nhExp = str.innerToken('\'', true)) == null) {
                    throw new ParseException(new EvalError("NativeHint requires hint expression. Ex: native('ORDERED')", this, str));
                }
                nh.setHintExpression(nhExp);
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.popChar() != ')') {
                    throw new ParseException(new EvalError(") expected.", this, str));
                }
                return nh;
            }
            case "BIND": {
                BindHint bh = new BindHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                return bh;
            }
            case "NO_BIND": {
                NoBindHint nbh = new NoBindHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                return nbh;
            }
            case "CACHE": {
                CacheHint ch = new CacheHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.peekChar() != '(') {
                    return ch;
                }
                str.consumeChars(1);
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.equalsNextToken("TRANSACTION", ParseContext.TOKEN_DELIMITERS)) {
                    ch.setScope(CacheHint.CacheScope.TRANSACTION);
                    str.consumeChars("TRANSACTION".length());
                    str.consumeChars(ParseContext.WHITE_SPACES);
                } else if (str.equalsNextToken("KEEP", ParseContext.TOKEN_DELIMITERS)) {
                    ch.setScope(CacheHint.CacheScope.GLOBAL_KEEP);
                    str.consumeChars("KEEP".length());
                    str.consumeChars(ParseContext.WHITE_SPACES);
                    if (str.peekChar() == ',') {
                        str.consumeChars(1);
                        str.consumeChars(ParseContext.WHITE_SPACES);
                        this.setTtl(str, ch);
                    }
                } else if (str.equalsNextToken("RELOAD", ParseContext.TOKEN_DELIMITERS)) {
                    ch.setScope(CacheHint.CacheScope.GLOBAL_RELOAD);
                    str.consumeChars("RELOAD".length());
                    str.consumeChars(ParseContext.WHITE_SPACES);
                    if (str.peekChar() == ',') {
                        str.consumeChars(1);
                        str.consumeChars(ParseContext.WHITE_SPACES);
                        this.setTtl(str, ch);
                    }
                    if (ch.getTTL() <= 0) {
                        throw new ParseException(new EvalError("CacheHint(GLOBAL_RELOAD) requires TTL value. Ex: cache(reload, 300)", this, str));
                    }
                } else {
                    this.setTtl(str, ch);
                }
                if (str.peekChar() != ')') {
                    throw new ParseException(new EvalError(") expected.", this, str));
                }
                str.consumeChars(1);
                str.consumeChars(ParseContext.WHITE_SPACES);
                return ch;
            }
            case "FETCH_SIZE": {
                FetchSizeHint fsh = new FetchSizeHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.popChar() != '(') {
                    throw new ParseException(new EvalError("( expected.", this, str));
                }
                str.consumeChars(ParseContext.WHITE_SPACES);
                String sizeStr = str.nextToken(RIGHT_PAREN_DELS);
                try {
                    fsh.setSize(Integer.parseInt(sizeStr.trim()));
                }
                catch (NumberFormatException e) {
                    throw new ParseException(new EvalError("invalid size value.", this, str));
                }
                str.consumeChars(1);
                str.consumeChars(ParseContext.WHITE_SPACES);
                return fsh;
            }
            case "TIMEOUT": {
                TimeoutHint th = new TimeoutHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.popChar() != '(') {
                    throw new ParseException(new EvalError("( expected.", this, str));
                }
                str.consumeChars(ParseContext.WHITE_SPACES);
                String secStr = str.nextToken(RIGHT_PAREN_DELS);
                try {
                    th.setSeconds(Integer.parseInt(secStr.trim()));
                }
                catch (NumberFormatException e) {
                    throw new ParseException(new EvalError("invalid seconds value.", this, str));
                }
                str.consumeChars(1);
                str.consumeChars(ParseContext.WHITE_SPACES);
                return th;
            }
            case "SUPPRESS_WARNINGS": {
                SuppressWarningsHint swh = new SuppressWarningsHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                return swh;
            }
            case "READ_ONLY": {
                ReadOnlyHint roh = new ReadOnlyHint();
                str.consumeChars(ParseContext.WHITE_SPACES);
                return roh;
            }
        }
        str.setCurrentIndex(currentIndex);
        throw new ParseException(new EvalError("hint clause(INDEX/NO_INDEX/NATIVE/BIND/CACHE/FETCH_SIZE/TIMEOUT/SUPPRESS_WARNINGS/READ_ONLY) expected.", this, str));
    }

    private void setTtl(ParseContext str, CacheHint ch) throws ParseException {
        String ttlStr = str.nextToken(RIGHT_PAREN_DELS);
        if (ttlStr != null) {
            try {
                ch.setTTL(Integer.parseInt(ttlStr.trim()));
            }
            catch (NumberFormatException e) {
                throw new ParseException(new EvalError("invalid TTL(or TRANSACTION/KEEP/RELOAD scope) value on cache hint.", this, str));
            }
        }
    }
}

