/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.prepared;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.codehaus.groovy.runtime.MethodClosure;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;

public class PreparedQueryBinding
extends GroovyTemplateBinding {
    private GregorianCalendar forDateCalc;
    private GregorianCalendar forDateCalcLocal;

    public PreparedQueryBinding(Timestamp date, UserBinding user, Map<String, Object> additionalBinding) {
        super(null);
        this.setVariable("toDateString", new MethodClosure((Object)this, "toDateString"));
        this.setVariable("toLocalDateString", new MethodClosure((Object)this, "toLocalDateString"));
        this.setVariable("toDateTimeString", new MethodClosure((Object)this, "toDateTimeString"));
        this.setVariable("toTimeString", new MethodClosure((Object)this, "toTimeString"));
        this.setVariable("toLocalTimeString", new MethodClosure((Object)this, "toLocalTimeString"));
        this.setVariable("addYear", new MethodClosure((Object)this, "addYear"));
        this.setVariable("addMonth", new MethodClosure((Object)this, "addMonth"));
        this.setVariable("addWeek", new MethodClosure((Object)this, "addWeek"));
        this.setVariable("addDay", new MethodClosure((Object)this, "addDay"));
        this.setVariable("addHour", new MethodClosure((Object)this, "addHour"));
        this.setVariable("addMinute", new MethodClosure((Object)this, "addMinute"));
        this.setVariable("addSecond", new MethodClosure((Object)this, "addSecond"));
        this.setVariable("addMillisecond", new MethodClosure((Object)this, "addMillisecond"));
        this.setVariable("toIn", new MethodClosure((Object)this, "toIn"));
        this.setVariable("date", date);
        this.setVariable("user", user);
        this.setVariable("sysdate", ConvertUtil.formatDate(date, "yyyy-MM-dd", true));
        this.setVariable("sysdatetime", ConvertUtil.formatDate(date, "yyyy-MM-dd HH:mm:ss.SSS", true));
        this.setVariable("systime", ConvertUtil.formatDate(date, "HH:mm:ss", true));
        if (additionalBinding != null) {
            for (Map.Entry<String, Object> e : additionalBinding.entrySet()) {
                this.setVariable(e.getKey(), e.getValue());
            }
        }
    }

    public String toDateString(Date date) {
        return ConvertUtil.formatDate(date, "yyyy-MM-dd", false);
    }

    public String toLocalDateString(Date date) {
        return ConvertUtil.formatDate(date, "yyyy-MM-dd", true);
    }

    public String toDateTimeString(Date date) {
        return ConvertUtil.formatDate(date, "yyyy-MM-dd HH:mm:ss.SSS", true);
    }

    public String toTimeString(Date date) {
        return ConvertUtil.formatDate(date, "HH:mm:ss", false);
    }

    public String toLocalTimeString(Date date) {
        return ConvertUtil.formatDate(date, "HH:mm:ss", true);
    }

    private Date calcCal(Date date, int field, int amount) {
        if (date instanceof java.sql.Date) {
            if (this.forDateCalc == null) {
                this.forDateCalc = DateUtil.getGregorianCalendar(false);
            }
            this.forDateCalc.setTime(date);
            this.forDateCalc.add(field, amount);
            return new java.sql.Date(this.forDateCalc.getTimeInMillis());
        }
        if (date instanceof Timestamp) {
            if (this.forDateCalcLocal == null) {
                this.forDateCalcLocal = DateUtil.getGregorianCalendar(true);
            }
            this.forDateCalcLocal.setTime(date);
            this.forDateCalcLocal.add(field, amount);
            return new Timestamp(this.forDateCalcLocal.getTimeInMillis());
        }
        if (date instanceof Time) {
            if (this.forDateCalc == null) {
                this.forDateCalc = DateUtil.getGregorianCalendar(false);
            }
            this.forDateCalc.setTime(date);
            this.forDateCalc.add(field, amount);
            return Time.valueOf(new Time(date.getTime()).toString());
        }
        if (this.forDateCalcLocal == null) {
            this.forDateCalcLocal = DateUtil.getGregorianCalendar(true);
        }
        this.forDateCalcLocal.setTime(date);
        this.forDateCalcLocal.add(field, amount);
        return this.forDateCalcLocal.getTime();
    }

    public Date addYear(Date date, int year) {
        return this.calcCal(date, 1, year);
    }

    public Date addMonth(Date date, int month) {
        return this.calcCal(date, 2, month);
    }

    public Date addWeek(Date date, int week) {
        return this.calcCal(date, 3, week);
    }

    public Date addDay(Date date, int day) {
        return this.calcCal(date, 5, day);
    }

    public Date addHour(Date date, int hour) {
        return this.calcCal(date, 11, hour);
    }

    public Date addMinute(Date date, int minute) {
        return this.calcCal(date, 12, minute);
    }

    public Date addSecond(Date date, int second) {
        return this.calcCal(date, 13, second);
    }

    public Date addMillisecond(Date date, int millisecond) {
        return this.calcCal(date, 14, millisecond);
    }

    public String toIn(Object values) {
        if (values == null) {
            return "null";
        }
        if (values instanceof Collection) {
            Collection l = (Collection)values;
            if (l.size() == 0) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Object v : l) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                if (v instanceof Collection) {
                    this.strRowValueListExp((Collection)v, sb);
                    continue;
                }
                if (v instanceof Object[]) {
                    this.strRowValueListExp((Object[])v, sb);
                    continue;
                }
                this.strExp(v, sb);
            }
            return sb.toString();
        }
        if (values instanceof Object[]) {
            Object[] l = (Object[])values;
            if (l.length == 0) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Object v : l) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                if (v instanceof Collection) {
                    this.strRowValueListExp((Collection)v, sb);
                    continue;
                }
                if (v instanceof Object[]) {
                    this.strRowValueListExp((Object[])v, sb);
                    continue;
                }
                this.strExp(v, sb);
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        this.strExp(values, sb);
        return sb.toString();
    }

    private void strRowValueListExp(Collection<?> vals, StringBuilder sb) {
        sb.append('(');
        boolean isFirst = true;
        for (Object v : vals) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            this.strExp(v, sb);
        }
        sb.append(')');
    }

    private void strRowValueListExp(Object[] vals, StringBuilder sb) {
        sb.append('(');
        boolean isFirst = true;
        for (Object v : vals) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            this.strExp(v, sb);
        }
        sb.append(')');
    }

    private void strExp(Object val, StringBuilder sb) {
        if (val == null) {
            sb.append("null");
        } else if (val instanceof ValueExpression) {
            sb.append(val.toString());
        } else if (val instanceof SelectValue) {
            sb.append('\'');
            sb.append(StringUtil.escapeEql(((SelectValue)val).getValue()));
            sb.append('\'');
        } else if (val instanceof String) {
            sb.append('\'');
            sb.append(StringUtil.escapeEql((String)val));
            sb.append('\'');
        } else if (val instanceof java.sql.Date) {
            sb.append('\'');
            sb.append(ConvertUtil.formatDate((java.sql.Date)val, "yyyy-MM-dd", false));
            sb.append('\'');
        } else if (val instanceof Timestamp) {
            sb.append('\'');
            sb.append(ConvertUtil.formatDate((Timestamp)val, "yyyy-MM-dd HH:mm:ss.SSS", true));
            sb.append('\'');
        } else if (val instanceof Time) {
            sb.append('\'');
            sb.append(ConvertUtil.formatDate((Time)val, "HH:mm:ss", false));
            sb.append('\'');
        } else {
            sb.append(StringUtil.escapeEql(val.toString()));
        }
    }
}

