/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.prepared;

import java.io.IOException;
import java.io.StringWriter;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.query.prepared.PreparedQueryBinding;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedQueryTemplate {
    private static final Logger logger = LoggerFactory.getLogger(PreparedQueryTemplate.class);
    private String queryString;
    private GroovyTemplate compiledQuery;

    public PreparedQueryTemplate(String queryString) {
        this.queryString = queryString;
        ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
        this.compiledQuery = GroovyTemplateCompiler.compile(queryString, "Query_" + GroovyTemplateCompiler.randomName(), (GroovyScriptEngine)se);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String doBind(PreparedQueryBinding binding) {
        StringWriter w = new StringWriter();
        binding.setVariable("out", w);
        try {
            this.compiledQuery.doTemplate(binding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("binding to expression: org:\"" + this.queryString + "\": binded:\"" + w.toString() + "\"");
        }
        return w.toString();
    }

    public Query query(PreparedQueryBinding binding) {
        return Query.newQuery(this.doBind(binding));
    }

    public Condition condition(PreparedQueryBinding binding) {
        String templateResult = this.doBind(binding);
        if (StringUtil.isBlank(templateResult)) {
            return null;
        }
        return Condition.newCondition(templateResult);
    }

    public ValueExpression value(PreparedQueryBinding binding) {
        return ValueExpression.newValue(this.doBind(binding));
    }
}

