/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class RowValueListSyntax
implements Syntax<RowValueList>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public RowValueList parse(ParseContext str) throws ParseException {
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars("(".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        ArrayList<ValueExpression> rowValues = new ArrayList<ValueExpression>();
        boolean isFirst = true;
        while (!str.startsWith(")") && !str.isEnd()) {
            if (isFirst) {
                isFirst = false;
            } else {
                if (!str.startsWith(",")) {
                    throw new ParseException(new EvalError(", expected.", this, str));
                }
                str.consumeChars(",".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            rowValues.add(this.polynomial.parse(str));
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(")".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (rowValues.size() < 2) {
            throw new ParseException(new EvalError("row value list expression must have at least two row value .", this, str));
        }
        RowValueList rowValueList = new RowValueList();
        rowValueList.setRowValues(rowValues);
        return rowValueList;
    }
}

