/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.controlflow;

import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.controlflow.When;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.condition.expr.OrSyntax;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class WhenSyntax
implements Syntax<When>,
QueryConstants {
    private OrSyntax or;
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.or = context.getSyntax(OrSyntax.class);
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public When parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("WHEN", ParseContext.WHITE_SPACES)) {
            throw new ParseException(new EvalError("WHEN expected.", this, str));
        }
        str.consumeChars("WHEN".length());
        When when = new When();
        if (!str.consumeChars(ParseContext.WHITE_SPACES)) {
            throw new ParseException(new EvalError("space expected.", this, str));
        }
        Condition cond = this.or.parse(str);
        when.setCondition(cond);
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.equalsNextToken("THEN", ParseContext.WHITE_SPACES)) {
            throw new ParseException(new EvalError("THEN expected.", this, str));
        }
        str.consumeChars("THEN".length());
        if (!str.consumeChars(ParseContext.WHITE_SPACES)) {
            throw new ParseException(new EvalError("space expected.", this, str));
        }
        ValueExpression result = this.polynomial.parse(str);
        when.setResult(result);
        return when;
    }
}

