/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.primary;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.ArrayValue;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class ArrayValueSyntax
implements Syntax<ArrayValue>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public ArrayValue parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("ARRAY", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("array expected.", this, str));
        }
        ArrayValue array = new ArrayValue();
        str.consumeChars("ARRAY".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith("[")) {
            throw new ParseException(new EvalError("[ expected.", this, str));
        }
        str.consumeChars("[".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        ArrayList<ValueExpression> values = new ArrayList<ValueExpression>();
        boolean isFirst = true;
        while (!str.startsWith("]") && !str.isEnd()) {
            if (isFirst) {
                isFirst = false;
            } else {
                if (!str.startsWith(",")) {
                    throw new ParseException(new EvalError(", expected.", this, str));
                }
                str.consumeChars(",".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            values.add(this.polynomial.parse(str));
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (!str.startsWith("]")) {
            throw new ParseException(new EvalError("] expected.", this, str));
        }
        str.consumeChars("]".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (values.size() != 0) {
            array.setValues(values);
        }
        return array;
    }
}

