/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.primary;

import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.controlflow.CaseSyntax;
import org.iplass.mtp.impl.query.value.primary.ArrayValueSyntax;
import org.iplass.mtp.impl.query.value.primary.CastSyntax;
import org.iplass.mtp.impl.query.value.primary.EntityFieldSyntax;
import org.iplass.mtp.impl.query.value.primary.FunctionSyntax;
import org.iplass.mtp.impl.query.value.primary.LiteralSyntax;
import org.iplass.mtp.impl.query.value.primary.ParenValueSyntax;
import org.iplass.mtp.impl.query.value.subquery.ScalarSubQuerySyntax;
import org.iplass.mtp.impl.query.value.window.WindowFunctionSyntax;

public class PrimaryValueSyntax
implements Syntax<ValueExpression>,
QueryConstants {
    private ParenValueSyntax bracketValue;
    private EntityFieldSyntax entityField;
    private CastSyntax cast;
    private FunctionSyntax function;
    private LiteralSyntax literal;
    private ScalarSubQuerySyntax scalarSubQuery;
    private WindowFunctionSyntax windowFunction;
    private ArrayValueSyntax arrayValue;
    private CaseSyntax caseClause;

    @Override
    public void init(SyntaxContext context) {
        this.scalarSubQuery = context.getSyntax(ScalarSubQuerySyntax.class);
        this.bracketValue = context.getSyntax(ParenValueSyntax.class);
        this.windowFunction = context.getSyntax(WindowFunctionSyntax.class);
        this.function = context.getSyntax(FunctionSyntax.class);
        this.cast = context.getSyntax(CastSyntax.class);
        this.entityField = context.getSyntax(EntityFieldSyntax.class);
        this.literal = context.getSyntax(LiteralSyntax.class);
        this.arrayValue = context.getSyntax(ArrayValueSyntax.class);
        this.caseClause = context.getSyntax(CaseSyntax.class);
    }

    @Override
    public ValueExpression parse(ParseContext str) throws ParseException {
        if (str.startsWith("(")) {
            int currentIndex = str.getCurrentIndex();
            try {
                return this.bracketValue.parse(str);
            }
            catch (ParseException e) {
                str.setCurrentIndex(currentIndex);
                return this.scalarSubQuery.parse(str);
            }
        }
        if (str.equalsNextToken("CASE", ParseContext.WHITE_SPACES)) {
            return this.caseClause.parse(str);
        }
        if (str.isEnd()) {
            throw new ParseException(new EvalError("can't parse value.", this, str));
        }
        int currentIndex = str.getCurrentIndex();
        try {
            return this.arrayValue.parse(str);
        }
        catch (ParseException e) {
            str.setCurrentIndex(currentIndex);
            try {
                return this.literal.parse(str);
            }
            catch (ParseException e2) {
                str.setCurrentIndex(currentIndex);
                try {
                    return this.windowFunction.parse(str);
                }
                catch (ParseException e3) {
                    str.setCurrentIndex(currentIndex);
                    try {
                        return this.cast.parse(str);
                    }
                    catch (ParseException e4) {
                        str.setCurrentIndex(currentIndex);
                        try {
                            return this.function.parse(str);
                        }
                        catch (ParseException e5) {
                            str.setCurrentIndex(currentIndex);
                            try {
                                return this.entityField.parse(str);
                            }
                            catch (ParseException e6) {
                                str.setCurrentIndex(currentIndex);
                                throw new ParseException(new EvalError("can't parse value.", this, str));
                            }
                        }
                    }
                }
            }
        }
    }
}

