/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityDuplicateValueException;
import org.iplass.mtp.entity.EntityQueryTimeoutException;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.EntityValueCastException;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlExecuter<R> {
    RdbAdapter rdb;
    Connection con;
    Statement stmt;
    List<PreparedStatement> pstmt;
    String connectionFactoryName;

    public Connection getConnection() throws SQLException {
        if (this.con == null) {
            this.con = this.rdb.getConnection(this.connectionFactoryName);
        }
        return this.con;
    }

    public PreparedStatement getPreparedStatement(String sql, String[] columnNames) throws SQLException {
        if (this.pstmt == null) {
            this.pstmt = new ArrayList<PreparedStatement>();
        }
        PreparedStatement ps = this.getConnection().prepareStatement(sql, columnNames);
        if (this.rdb.getDefaultQueryTimeout() != ps.getQueryTimeout()) {
            ps.setQueryTimeout(this.rdb.getDefaultQueryTimeout());
        }
        if (this.rdb.getDefaultFetchSize() >= 0 && this.rdb.getDefaultFetchSize() != ps.getFetchSize()) {
            ps.setFetchSize(this.rdb.getDefaultFetchSize());
        }
        this.pstmt.add(ps);
        return ps;
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        if (this.pstmt == null) {
            this.pstmt = new ArrayList<PreparedStatement>();
        }
        PreparedStatement ps = this.getConnection().prepareStatement(sql);
        if (this.rdb.getDefaultQueryTimeout() != ps.getQueryTimeout()) {
            ps.setQueryTimeout(this.rdb.getDefaultQueryTimeout());
        }
        if (this.rdb.getDefaultFetchSize() >= 0 && this.rdb.getDefaultFetchSize() != ps.getFetchSize()) {
            ps.setFetchSize(this.rdb.getDefaultFetchSize());
        }
        this.pstmt.add(ps);
        return ps;
    }

    public Statement getStatement() throws SQLException {
        if (this.stmt == null) {
            this.stmt = this.getConnection().createStatement();
            if (this.rdb.getDefaultQueryTimeout() != this.stmt.getQueryTimeout()) {
                this.stmt.setQueryTimeout(this.rdb.getDefaultQueryTimeout());
            }
            if (this.rdb.getDefaultFetchSize() >= 0 && this.rdb.getDefaultFetchSize() != this.stmt.getFetchSize()) {
                this.stmt.setFetchSize(this.rdb.getDefaultFetchSize());
            }
        }
        return this.stmt;
    }

    public R execute(RdbAdapter rdb, boolean withResourceClose) {
        return this.execute(null, rdb, withResourceClose);
    }

    public R execute(String connectionFactoryName, RdbAdapter rdb, boolean withResourceClose) {
        this.rdb = rdb;
        this.connectionFactoryName = connectionFactoryName;
        if (withResourceClose) {
            try {
                R r = this.logic();
                return r;
            }
            catch (SQLException e) {
                if (e instanceof SQLTimeoutException) {
                    throw new EntityQueryTimeoutException(SqlExecuter.resourceString("impl.entity.queryTimeout", new Object[0]), e);
                }
                if (rdb.isDuplicateValueException(e)) {
                    throw new EntityDuplicateValueException(SqlExecuter.resourceString("impl.transaction.LocalTransaction.duplicate", new Object[0]), e);
                }
                if (rdb.isDeadLock(e)) {
                    EntityConcurrentUpdateException ecue = new EntityConcurrentUpdateException(SqlExecuter.resourceString("spi.rdb.SqlExecuter.cantUpdate", new Object[0]), e);
                    ecue.setDeadLock(true);
                    throw ecue;
                }
                if (rdb.isLockFailed(e)) {
                    EntityConcurrentUpdateException ecue = new EntityConcurrentUpdateException(SqlExecuter.resourceString("spi.rdb.SqlExecuter.cantUpdate", new Object[0]), e);
                    ecue.setNowait(true);
                    throw ecue;
                }
                if (rdb.isCastFailed(e)) {
                    throw new EntityValueCastException(SqlExecuter.resourceString("spi.rdb.SqlExecuter.cantCast", new Object[0]), e);
                }
                throw new EntityRuntimeException(e);
            }
            finally {
                this.close();
            }
        }
        try {
            return this.logic();
        }
        catch (SQLException e) {
            this.close();
            if (e instanceof SQLTimeoutException) {
                throw new EntityQueryTimeoutException(SqlExecuter.resourceString("impl.entity.queryTimeout", new Object[0]), e);
            }
            if (rdb.isDuplicateValueException(e)) {
                throw new EntityDuplicateValueException(SqlExecuter.resourceString("impl.transaction.LocalTransaction.duplicate", new Object[0]), e);
            }
            if (rdb.isDeadLock(e)) {
                EntityConcurrentUpdateException ecue = new EntityConcurrentUpdateException(e);
                ecue.setDeadLock(true);
                throw ecue;
            }
            if (rdb.isLockFailed(e)) {
                EntityConcurrentUpdateException ecue = new EntityConcurrentUpdateException(e);
                ecue.setNowait(true);
                throw ecue;
            }
            if (rdb.isCastFailed(e)) {
                throw new EntityValueCastException(SqlExecuter.resourceString("spi.rdb.SqlExecuter.cantCast", new Object[0]), e);
            }
            throw new EntityRuntimeException(e);
        }
    }

    public void statementClose() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (SQLException e) {
                this.logFailResourceCleaning(e);
            }
        }
    }

    public void close() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (SQLException e) {
                this.logFailResourceCleaning(e);
            }
        }
        if (this.pstmt != null) {
            for (PreparedStatement ps : this.pstmt) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    this.logFailResourceCleaning(e);
                }
            }
            this.pstmt = null;
        }
        if (this.con != null) {
            try {
                this.con.close();
                this.con = null;
            }
            catch (SQLException e) {
                this.logFailResourceCleaning(e);
            }
        }
    }

    public abstract R logic() throws SQLException;

    private void logFailResourceCleaning(Exception e) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
    }

    public static <R> R execute(RdbAdapter rdb, SqlExecuter<R> exec) {
        return exec.execute(rdb, true);
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

