/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.impl.entity.property.PropertyService;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.properties.basic.DecimalType;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbTypeAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public abstract class BaseRdbTypeAdapter
implements RdbTypeAdapter {
    private static Map<Class<? extends BaseRdbTypeAdapter>, BaseRdbTypeAdapter> map;
    protected PropertyType propertyType;

    public static BaseRdbTypeAdapter getInstance(Class<? extends BaseRdbTypeAdapter> type) {
        return map.get(type);
    }

    public static List<BaseRdbTypeAdapter> values() {
        ArrayList<BaseRdbTypeAdapter> values = new ArrayList<BaseRdbTypeAdapter>();
        for (BaseRdbTypeAdapter adaptor : map.values()) {
            values.add(adaptor);
        }
        return values;
    }

    public BaseRdbTypeAdapter(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    @Override
    public int allocateColumnCount() {
        return 1;
    }

    public abstract int sqlType();

    public Object toDataStore(Object javaTypeValue, RdbAdapter rdb) {
        return this.toRdb(this.propertyType.toDataStore(javaTypeValue), rdb);
    }

    public Object fromDataStore(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
        return this.propertyType.fromDataStore(this.toJava(rs, columnIndex, rdb));
    }

    protected abstract Object toRdb(Object var1, RdbAdapter var2);

    protected abstract Object toJava(ResultSet var1, int var2, RdbAdapter var3) throws SQLException;

    public abstract String getColOfIndex();

    public void appendToSqlAsRealType(Object javaTypeValue, StringBuilder context, RdbAdapter rdb) {
        context.append(rdb.toSqlExp(this.toDataStore(javaTypeValue, rdb)));
    }

    public abstract void setParameter(int var1, Object var2, PreparedStatement var3, RdbAdapter var4) throws SQLException;

    public void appendToTypedCol(StringBuilder context, RdbAdapter rdb, ValueHandleLogic callback) {
        callback.run();
    }

    public void appendFromTypedCol(StringBuilder context, RdbAdapter rdb, ValueHandleLogic callback) {
        callback.run();
    }

    public void appendParameterPlaceholder(StringBuilder context, RdbAdapter rdb) {
        context.append("?");
    }

    static {
        PropertyService ps = ServiceRegistry.getRegistry().getService(PropertyService.class);
        map = new HashMap<Class<? extends BaseRdbTypeAdapter>, BaseRdbTypeAdapter>();
        map.put(Null.class, new Null());
        map.put(DateTime.class, new DateTime(ps.getPropertyType(Timestamp.class)));
        map.put(Date.class, new Date(ps.getPropertyType(java.sql.Date.class)));
        map.put(Time.class, new Time(ps.getPropertyType(java.sql.Time.class)));
        map.put(Float.class, new Float(ps.getPropertyType(Double.class)));
        map.put(Integer.class, new Integer(ps.getPropertyType(Long.class)));
        map.put(Varchar.class, new Varchar(ps.getPropertyType(String.class)));
        map.put(Bool.class, new Bool(ps.getPropertyType(Boolean.class)));
    }

    public static class Bool
    extends BaseRdbTypeAdapter {
        public Bool(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        protected Boolean toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            String val = rs.getString(columnIndex);
            if (val == null) {
                return null;
            }
            if (val.length() == 0) {
                return null;
            }
            if (val.equals("0")) {
                return Boolean.FALSE;
            }
            if (val.equals("1")) {
                return Boolean.TRUE;
            }
            return null;
        }

        @Override
        protected String toRdb(Object javaTypeValue, RdbAdapter rdb) {
            if (javaTypeValue == null) {
                return null;
            }
            Boolean val = null;
            val = javaTypeValue instanceof Boolean ? (Boolean)javaTypeValue : Boolean.valueOf(javaTypeValue.toString());
            if (!val.booleanValue()) {
                return "0";
            }
            return "1";
        }

        @Override
        public void appendToSqlAsRealType(Object javaTypeValue, StringBuilder context, RdbAdapter rdb) {
            String val = this.toRdb(javaTypeValue, rdb);
            if (val == null) {
                context.append("null");
            } else {
                context.append("'").append(rdb.sanitize(val)).append("'");
            }
        }

        @Override
        public String getColOfIndex() {
            return "STR";
        }

        @Override
        public int sqlType() {
            return 12;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            String val = this.toRdb(javaTypeValue, rdb);
            stmt.setString(index, val);
        }
    }

    public static class Varchar
    extends BaseRdbTypeAdapter {
        public Varchar(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        protected String toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            return rs.getString(columnIndex);
        }

        @Override
        protected String toRdb(Object javaTypeValue, RdbAdapter rdb) {
            if (javaTypeValue == null) {
                return null;
            }
            return javaTypeValue.toString();
        }

        @Override
        public void appendToSqlAsRealType(Object javaTypeValue, StringBuilder context, RdbAdapter rdb) {
            String val = this.toRdb(javaTypeValue, rdb);
            if (val == null) {
                context.append("null");
            } else {
                context.append("'").append(rdb.sanitize(val)).append("'");
            }
        }

        @Override
        public String getColOfIndex() {
            return "STR";
        }

        @Override
        public int sqlType() {
            return 12;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            String val = this.toRdb(javaTypeValue, rdb);
            stmt.setString(index, val);
        }
    }

    public static class Time
    extends BaseRdbTypeAdapter {
        public Time(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        protected java.sql.Time toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            return rs.getTime(columnIndex, rdb.javaCalendar());
        }

        @Override
        protected java.sql.Time toRdb(Object javaTypeValue, RdbAdapter rdb) {
            if (javaTypeValue == null) {
                return null;
            }
            if (javaTypeValue instanceof java.sql.Time) {
                return (java.sql.Time)javaTypeValue;
            }
            if (javaTypeValue instanceof java.util.Date) {
                return new java.sql.Time(((java.util.Date)javaTypeValue).getTime());
            }
            return java.sql.Time.valueOf(javaTypeValue.toString());
        }

        @Override
        public void appendToSqlAsRealType(Object javaTypeValue, StringBuilder context, RdbAdapter rdb) {
            java.sql.Time val = this.toRdb(javaTypeValue, rdb);
            if (val == null) {
                context.append("null");
            } else {
                context.append(rdb.toTimeExpression(val));
            }
        }

        @Override
        public String getColOfIndex() {
            return "TS";
        }

        @Override
        public int sqlType() {
            return 92;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            java.sql.Time val = this.toRdb(javaTypeValue, rdb);
            if (val != null) {
                SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss");
                val = java.sql.Time.valueOf(fmt.format(val));
            }
            stmt.setTime(index, val);
        }
    }

    public static class Integer
    extends BaseRdbTypeAdapter {
        public Integer(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        protected Long toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return rs.getLong(columnIndex);
        }

        @Override
        protected Long toRdb(Object javaTypeValue, RdbAdapter rdb) {
            if (javaTypeValue == null) {
                return null;
            }
            if (javaTypeValue instanceof Long) {
                return (Long)javaTypeValue;
            }
            if (javaTypeValue instanceof Number) {
                return ((Number)javaTypeValue).longValue();
            }
            return Long.parseLong(javaTypeValue.toString());
        }

        @Override
        public String getColOfIndex() {
            return "NUM";
        }

        @Override
        public int sqlType() {
            return -5;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            Long val = this.toRdb(javaTypeValue, rdb);
            if (val == null) {
                stmt.setNull(index, this.sqlType());
            } else {
                stmt.setLong(index, val);
            }
        }
    }

    public static class Float
    extends BaseRdbTypeAdapter {
        public Float(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        public Double toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return rs.getDouble(columnIndex);
        }

        @Override
        protected Double toRdb(Object javaTypeValue, RdbAdapter rdb) {
            if (javaTypeValue == null) {
                return null;
            }
            if (javaTypeValue instanceof Double) {
                return (Double)javaTypeValue;
            }
            if (javaTypeValue instanceof Number) {
                return ((Number)javaTypeValue).doubleValue();
            }
            return Double.parseDouble(javaTypeValue.toString());
        }

        @Override
        public String getColOfIndex() {
            return "DBL";
        }

        @Override
        public int sqlType() {
            return 8;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            Double val = this.toRdb(javaTypeValue, rdb);
            if (val == null) {
                stmt.setNull(index, this.sqlType());
            } else {
                stmt.setDouble(index, val);
            }
        }
    }

    public static class Decimal
    extends BaseRdbTypeAdapter {
        public Decimal(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        public void appendFromTypedCol(StringBuilder context, RdbAdapter rdb, ValueHandleLogic callback) {
            DecimalType type = (DecimalType)this.propertyType;
            if (type.getScale() < 0) {
                context.append("1");
                for (int i = 0; i > type.getScale(); --i) {
                    context.append("0");
                }
                context.append("*(");
                super.appendToTypedCol(context, rdb, callback);
                context.append(")");
            } else if (type.getScale() > 0) {
                context.append("(");
                super.appendToTypedCol(context, rdb, callback);
                context.append(")/");
                context.append("1");
                for (int i = 0; i < type.getScale(); ++i) {
                    context.append("0");
                }
            } else {
                super.appendToTypedCol(context, rdb, callback);
            }
        }

        @Override
        public void appendToTypedCol(StringBuilder context, RdbAdapter rdb, ValueHandleLogic callback) {
            DecimalType type = (DecimalType)this.propertyType;
            if (type.getScale() > 0) {
                context.append("1");
                for (int i = 0; i < type.getScale(); ++i) {
                    context.append("0");
                }
                context.append("*(");
                super.appendToTypedCol(context, rdb, callback);
                context.append(")");
            } else if (type.getScale() < 0) {
                context.append("(");
                super.appendToTypedCol(context, rdb, callback);
                context.append(")/");
                context.append("1");
                for (int i = 0; i > type.getScale(); --i) {
                    context.append("0");
                }
            } else {
                super.appendToTypedCol(context, rdb, callback);
            }
        }

        @Override
        protected BigDecimal toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            BigDecimal dec = rs.getBigDecimal(columnIndex);
            if (dec != null && dec.scale() != ((DecimalType)this.propertyType).getScale() && ((DecimalType)this.propertyType).getScale() != java.lang.Integer.MIN_VALUE) {
                RoundingMode rm = ((DecimalType)this.propertyType).getRoundingMode();
                if (rm == null) {
                    rm = RoundingMode.HALF_EVEN;
                }
                dec = dec.setScale(((DecimalType)this.propertyType).getScale(), rm);
            }
            return dec;
        }

        @Override
        protected BigDecimal toRdb(Object javaTypeValue, RdbAdapter rdb) {
            return (BigDecimal)javaTypeValue;
        }

        @Override
        public String getColOfIndex() {
            return "NUM";
        }

        @Override
        public int sqlType() {
            return 3;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            BigDecimal val = (BigDecimal)this.toDataStore(javaTypeValue, rdb);
            stmt.setBigDecimal(index, val);
        }
    }

    public static class Date
    extends BaseRdbTypeAdapter {
        public Date(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        protected java.sql.Date toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            return rs.getDate(columnIndex, rdb.javaCalendar());
        }

        @Override
        protected java.sql.Date toRdb(Object javaTypeValue, RdbAdapter rdb) {
            if (javaTypeValue == null) {
                return null;
            }
            if (javaTypeValue instanceof java.sql.Date) {
                return (java.sql.Date)javaTypeValue;
            }
            if (javaTypeValue instanceof java.util.Date) {
                return new java.sql.Date(((java.util.Date)javaTypeValue).getTime());
            }
            try {
                return new java.sql.Date(DateFormat.getDateInstance(2).parse(javaTypeValue.toString()).getTime());
            }
            catch (ParseException e) {
                throw new EntityRuntimeException("can not convert to Date:" + javaTypeValue);
            }
        }

        @Override
        public void appendToSqlAsRealType(Object javaTypeValue, StringBuilder context, RdbAdapter rdb) {
            java.sql.Date date = this.toRdb(javaTypeValue, rdb);
            if (date == null) {
                context.append("null");
            } else {
                context.append(rdb.toDateExpression(date));
            }
        }

        @Override
        public String getColOfIndex() {
            return "DATE";
        }

        @Override
        public int sqlType() {
            return 91;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            java.sql.Date val = this.toRdb(javaTypeValue, rdb);
            stmt.setDate(index, val);
        }
    }

    public static class DateTime
    extends BaseRdbTypeAdapter {
        public DateTime(PropertyType propertyType) {
            super(propertyType);
        }

        @Override
        protected Timestamp toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            return rs.getTimestamp(columnIndex, rdb.rdbCalendar());
        }

        @Override
        protected Timestamp toRdb(Object javaTypeValue, RdbAdapter rdb) {
            if (javaTypeValue == null) {
                return null;
            }
            if (javaTypeValue instanceof Timestamp) {
                return (Timestamp)javaTypeValue;
            }
            if (javaTypeValue instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)javaTypeValue).getTime());
            }
            try {
                return new Timestamp(DateFormat.getDateTimeInstance(2, 2).parse(javaTypeValue.toString()).getTime());
            }
            catch (ParseException e) {
                throw new EntityRuntimeException("can not convert to Date:" + javaTypeValue);
            }
        }

        @Override
        public void appendToSqlAsRealType(Object javaTypeValue, StringBuilder context, RdbAdapter rdb) {
            Timestamp ts = this.toRdb(javaTypeValue, rdb);
            if (ts == null) {
                context.append("null");
            } else {
                context.append(rdb.toTimeStampExpression(ts));
            }
        }

        @Override
        public String getColOfIndex() {
            return "TS";
        }

        @Override
        public int sqlType() {
            return 93;
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            Timestamp val = this.toRdb(javaTypeValue, rdb);
            stmt.setTimestamp(index, val, rdb.rdbCalendar());
        }
    }

    public static class Null
    extends BaseRdbTypeAdapter {
        public Null() {
            super(null);
        }

        @Override
        public Object fromDataStore(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            return null;
        }

        @Override
        public Object toDataStore(Object javaTypeValue, RdbAdapter rdb) {
            return null;
        }

        @Override
        public String getColOfIndex() {
            return null;
        }

        @Override
        protected Object toJava(ResultSet rs, int columnIndex, RdbAdapter rdb) throws SQLException {
            return null;
        }

        @Override
        protected Object toRdb(Object javaTypeValue, RdbAdapter rdb) {
            return null;
        }

        @Override
        public int sqlType() {
            return 0;
        }

        @Override
        public void appendToSqlAsRealType(Object javaTypeValue, StringBuilder context, RdbAdapter rdb) {
            context.append("NULL");
        }

        @Override
        public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
            stmt.setNull(index, 0);
        }
    }

    public static interface ValueHandleLogic {
        public void run();
    }

    public static class ColumnIndexType {
        public static final String DATE = "DATE";
        public static final String DOUBLE = "DBL";
        public static final String NUMBER = "NUM";
        public static final String STRING = "STR";
        public static final String TIMESTAMP = "TS";
    }
}

