/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.window.CumeDist;
import org.iplass.mtp.entity.query.value.window.DenseRank;
import org.iplass.mtp.entity.query.value.window.PercentRank;
import org.iplass.mtp.entity.query.value.window.Rank;
import org.iplass.mtp.entity.query.value.window.RowNumber;
import org.iplass.mtp.entity.query.value.window.WindowRankFunction;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.properties.basic.BooleanType;
import org.iplass.mtp.impl.properties.basic.DateTimeType;
import org.iplass.mtp.impl.properties.basic.DateType;
import org.iplass.mtp.impl.properties.basic.DecimalType;
import org.iplass.mtp.impl.properties.basic.FloatType;
import org.iplass.mtp.impl.properties.basic.IntegerType;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.basic.TimeType;
import org.iplass.mtp.impl.properties.extend.WrapperType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.HintPlace;
import org.iplass.mtp.impl.rdb.adapter.MultiInsertContext;
import org.iplass.mtp.impl.rdb.adapter.MultiTableUpdateMethod;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.UnsupportedDataTypeException;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;
import org.iplass.mtp.impl.rdb.adapter.WrapperRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.function.AggregateFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;

public abstract class RdbAdapter {
    private String listaggDefaultSeparator = ",";
    private String rdbTimeZone;
    private TimeZone rdbTimeZoneInstance;
    private HashMap<String, FunctionAdapter<Function>> functionMap = new HashMap();
    private HashMap<Class<? extends Aggregate>, AggregateFunctionAdapter<? extends Aggregate>> aggMap = new HashMap();
    private HashMap<Class<? extends WindowRankFunction>, String> windowRankFuncNameMap = this.createWindowRankFuncNameMap();

    protected <T extends Aggregate> void addAggregateFunction(Class<T> aggType, AggregateFunctionAdapter<T> functionAdapter) {
        this.aggMap.put(aggType, functionAdapter);
    }

    protected void addFunction(FunctionAdapter<Function> functionAdapter) {
        this.functionMap.put(functionAdapter.getFunctionName().toLowerCase(), functionAdapter);
        this.functionMap.put(functionAdapter.getFunctionName().toUpperCase(), functionAdapter);
    }

    public <T extends UpdateSqlHandler> T getUpdateSqlCreator(Class<T> sqlCreatorClass) {
        try {
            return (T)((UpdateSqlHandler)sqlCreatorClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new EntityRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new EntityRuntimeException(e);
        }
    }

    public <T extends QuerySqlHandler> T getQuerySqlCreator(Class<T> sqlCreatorClass) {
        try {
            return (T)((QuerySqlHandler)sqlCreatorClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new EntityRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new EntityRuntimeException(e);
        }
    }

    public String[] castExp(int sqlType, Integer lengthOrPrecision, Integer scale) {
        String rdbType = this.getDataTypeOf(sqlType, lengthOrPrecision, scale);
        return new String[]{"CAST(", " AS " + rdbType + ")"};
    }

    public CharSequence cast(int fromSqlType, int toSqlType, CharSequence valExpr, Integer lengthOrPrecision, Integer scale) {
        String[] castExp = this.castExp(toSqlType, lengthOrPrecision, scale);
        if (castExp == null) {
            return valExpr;
        }
        return castExp[0] + valExpr + castExp[1];
    }

    public UnaryOperator<CharSequence> countQuery(Query q) {
        return sql -> "SELECT COUNT(*) FROM (" + sql + ") CT";
    }

    public abstract boolean isSupportOptimizerHint();

    public abstract String getOptimizerHint();

    public abstract HintPlace getOptimizerHintPlace();

    public abstract String[] getOptimizerHintBracket();

    public abstract boolean isSupportTableHint();

    public abstract String[] getTableHintBracket();

    protected abstract String getDataTypeOf(int var1, Integer var2, Integer var3);

    public BaseRdbTypeAdapter getRdbTypeAdapter(Object value) {
        if (value == null) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Null.class);
        }
        if (value instanceof String) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Varchar.class);
        }
        if (value instanceof Long || value instanceof Integer) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Integer.class);
        }
        if (value instanceof BigDecimal) {
            return new BaseRdbTypeAdapter.Decimal(new DecimalType(((BigDecimal)value).scale(), RoundingMode.HALF_EVEN));
        }
        if (value instanceof Date) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Date.class);
        }
        if (value instanceof Double || value instanceof Float) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Float.class);
        }
        if (value instanceof Time) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Time.class);
        }
        if (value instanceof Timestamp) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.DateTime.class);
        }
        if (value instanceof Boolean) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Bool.class);
        }
        return null;
    }

    public BaseRdbTypeAdapter getRdbTypeAdapter(PropertyType propType) {
        if (propType instanceof WrapperType) {
            PropertyType wrapped = ((WrapperType)propType).actualType();
            BaseRdbTypeAdapter actualAdapter = this.getRdbTypeAdapter(wrapped);
            return new WrapperRdbTypeAdapter(propType, actualAdapter);
        }
        if (propType instanceof BooleanType) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Bool.class);
        }
        if (propType instanceof DateTimeType) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.DateTime.class);
        }
        if (propType instanceof DateType) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Date.class);
        }
        if (propType instanceof TimeType) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Time.class);
        }
        if (propType instanceof DecimalType) {
            return new BaseRdbTypeAdapter.Decimal(propType);
        }
        if (propType instanceof FloatType) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Float.class);
        }
        if (propType instanceof IntegerType) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Integer.class);
        }
        if (propType instanceof StringType) {
            return BaseRdbTypeAdapter.getInstance(BaseRdbTypeAdapter.Varchar.class);
        }
        return null;
    }

    public String toSqlExp(Object rdbValue) {
        if (rdbValue == null) {
            return null;
        }
        if (rdbValue instanceof String) {
            return "'" + this.sanitize((String)rdbValue) + "'";
        }
        if (rdbValue instanceof Long || rdbValue instanceof Integer || rdbValue instanceof BigDecimal) {
            return rdbValue.toString();
        }
        if (rdbValue instanceof Date) {
            return this.toDateExpression((Date)rdbValue);
        }
        if (rdbValue instanceof Double) {
            return rdbValue.toString();
        }
        if (rdbValue instanceof Time) {
            return this.toTimeExpression((Time)rdbValue);
        }
        if (rdbValue instanceof Timestamp) {
            return this.toTimeStampExpression((Timestamp)rdbValue);
        }
        throw new UnsupportedDataTypeException("Unsupported Data Type:" + rdbValue.getClass().getName());
    }

    public void setParameter(PreparedStatement ps, int index, Object rdbValue) throws SQLException {
        if (rdbValue == null) {
            ps.setNull(index, 0);
        } else if (rdbValue instanceof String) {
            ps.setString(index, (String)rdbValue);
        } else if (rdbValue instanceof Integer) {
            ps.setInt(index, (Integer)rdbValue);
        } else if (rdbValue instanceof Long) {
            ps.setLong(index, (Long)rdbValue);
        } else if (rdbValue instanceof BigDecimal) {
            ps.setBigDecimal(index, (BigDecimal)rdbValue);
        } else if (rdbValue instanceof Date) {
            ps.setDate(index, (Date)rdbValue);
        } else if (rdbValue instanceof Double) {
            ps.setDouble(index, (Double)rdbValue);
        } else if (rdbValue instanceof Time) {
            ps.setTime(index, (Time)rdbValue);
        } else if (rdbValue instanceof Timestamp) {
            ps.setTimestamp(index, (Timestamp)rdbValue, this.rdbCalendar());
        } else {
            ps.setObject(index, rdbValue);
        }
    }

    public abstract String toDateExpression(Date var1);

    public abstract String toTimeExpression(Time var1);

    public abstract String toTimeStampExpression(Timestamp var1);

    public String sanitize(String str) {
        if (str == null) {
            return null;
        }
        boolean containsQuote = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\'') continue;
            containsQuote = true;
            break;
        }
        if (containsQuote) {
            StringBuilder sb = new StringBuilder();
            char c = '\u0000';
            for (int i = 0; i < str.length(); ++i) {
                c = str.charAt(i);
                if (c == '\'') {
                    sb.append('\'');
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return str;
    }

    public final FunctionAdapter<Function> resolveFunction(String name) {
        FunctionAdapter<Function> ret = this.functionMap.get(name);
        if (ret == null) {
            ret = this.functionMap.get(name.toUpperCase());
        }
        return ret;
    }

    public final <T extends Aggregate> AggregateFunctionAdapter<T> resolveAggregateFunction(Class<T> aggClass) {
        return this.aggMap.get(aggClass);
    }

    public abstract String systimestamp();

    public abstract MultiInsertContext createMultiInsertContext(Statement var1);

    public abstract BulkInsertContext createBulkInsertContext();

    public abstract BulkUpdateContext createBulkUpdateContext();

    public abstract BulkDeleteContext createBulkDeleteContext();

    public final Connection getConnection() throws SQLException {
        return this.getConnection(null);
    }

    public Connection getConnection(String connectionFactoryName) throws SQLException {
        if (connectionFactoryName == null) {
            return ServiceRegistry.getRegistry().getService(ConnectionFactory.class).getConnection();
        }
        return ((ConnectionFactory)ServiceRegistry.getRegistry().getService(connectionFactoryName)).getConnection();
    }

    public abstract String seqNextSelectSql(String var1, int var2, String var3);

    public abstract boolean isUseSubQueryForIndexJoin();

    public abstract String dual();

    public abstract String rowLockExpression();

    public String toLimitSql(String selectSql, int limitCount, int offset) {
        return this.toLimitSql(selectSql, limitCount, offset, false);
    }

    public abstract String toLimitSql(String var1, int var2, int var3, boolean var4);

    public abstract Object[] toLimitSqlBindValue(int var1, int var2);

    public abstract boolean isDuplicateValueException(SQLException var1);

    public abstract boolean isDeadLock(SQLException var1);

    public abstract boolean isLockFailed(SQLException var1);

    public abstract boolean isCastFailed(SQLException var1);

    public abstract String addDate(String var1, int var2);

    public abstract String checkStatusQuery();

    public final String sanitizeForLike(String str) {
        return this.likePattern(StringUtil.escapeEqlForLike(str));
    }

    public abstract String likePattern(String var1);

    public abstract String escape();

    public abstract String tableAlias(String var1);

    public abstract boolean isSupportGroupingExtention(GroupBy.RollType var1);

    public abstract boolean isSupportGroupingExtention();

    public abstract boolean isSupportGroupingExtentionWithOrderBy();

    public abstract String rollUpStart(GroupBy.RollType var1);

    public abstract String rollUpEnd(GroupBy.RollType var1);

    public abstract void appendSortSpecExpression(StringBuilder var1, CharSequence var2, SortSpec.SortType var3, SortSpec.NullOrderingSpec var4);

    public String getListaggDefaultSeparator() {
        return this.listaggDefaultSeparator;
    }

    public void setListaggDefaultSeparator(String listaggDefaultSeparator) {
        this.listaggDefaultSeparator = listaggDefaultSeparator;
    }

    public String getRdbTimeZone() {
        return this.rdbTimeZone;
    }

    public void setRdbTimeZone(String rdbTimeZone) {
        this.rdbTimeZone = rdbTimeZone;
        this.rdbTimeZoneInstance = rdbTimeZone == null ? null : TimeZone.getTimeZone(rdbTimeZone);
    }

    public TimeZone rdbTimeZone() {
        return this.rdbTimeZoneInstance;
    }

    public Calendar rdbCalendar() {
        TimeZone tz = this.rdbTimeZone();
        if (tz == null) {
            return null;
        }
        return Calendar.getInstance(tz);
    }

    public Calendar javaCalendar() {
        TimeZone tz = this.rdbTimeZone();
        if (tz == null) {
            return null;
        }
        return Calendar.getInstance();
    }

    public abstract String[] convertTZ(String var1);

    public String upperFunctionName() {
        return "UPPER";
    }

    public abstract String initBlob();

    public abstract boolean isEnableInPartitioning();

    public abstract int getInPartitioningSize();

    public abstract boolean isSupportGlobalTemporaryTable();

    public abstract boolean isSupportAutoClearTemporaryTableWhenCommit();

    public abstract String createLocalTemporaryTable(String var1, String var2, String[] var3);

    public abstract String deleteTemporaryTable(String var1);

    public abstract boolean isEnableBindHint();

    public abstract boolean isAlwaysBind();

    public abstract int getBatchSize();

    public abstract int getMaxFetchSize();

    public abstract int getDefaultQueryTimeout();

    public abstract int getDefaultFetchSize();

    public abstract int getThresholdCountOfUsePrepareStatement();

    public String aggregateFunctionName(Aggregate agg) {
        AggregateFunctionAdapter<? extends Aggregate> aa = this.aggMap.get(agg.getClass());
        if (aa != null) {
            return aa.getSqlFunctionName();
        }
        return null;
    }

    public abstract boolean isSupportWindowFunction();

    private HashMap<Class<? extends WindowRankFunction>, String> createWindowRankFuncNameMap() {
        HashMap<Class<? extends WindowRankFunction>, String> map = new HashMap<Class<? extends WindowRankFunction>, String>();
        map.put(CumeDist.class, "CUME_DIST");
        map.put(DenseRank.class, "DENSE_RANK");
        map.put(PercentRank.class, "PERCENT_RANK");
        map.put(Rank.class, "RANK");
        map.put(RowNumber.class, "ROW_NUMBER");
        return map;
    }

    public String windowRankFunctionName(WindowRankFunction rankFunc) {
        return this.windowRankFuncNameMap.get(rankFunc.getClass());
    }

    public abstract MultiTableUpdateMethod getMultiTableUpdateMethod();

    public abstract ResultSet getTableNames(String var1, Connection var2) throws SQLException;

    public String getTemplaryTablePrefix() {
        return "";
    }

    public String createRowLockSql(String sql) {
        return sql + " " + this.rowLockExpression();
    }

    public boolean isSupportRowValueConstructor() {
        return true;
    }

    public boolean isNeedFromClauseTableAliasUpdateStatement() {
        return false;
    }

    public boolean isSupportBlobType() {
        return true;
    }

    public String getDefaultOrderByForLimit() {
        return "";
    }

    public String getViewSubQueryAlias() {
        return "";
    }

    public int getMaxViewNameLength() {
        return -1;
    }

    public abstract String createViewColumnSql(int var1, String var2);

    public abstract String createBinaryViewColumnSql(int var1, String var2, String var3);

    public abstract String createLongTextViewColumnSql(int var1, String var2, String var3);

    public abstract String toCreateViewDDL(String var1, String var2, boolean var3);

    public boolean isNeedMultiTableTrick() {
        return false;
    }

    public String getMultiTableTrickClauseForUpdate() {
        return null;
    }
}

