/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.impl.rdb.adapter.NoopRdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbAdapterService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(RdbAdapterService.class);
    private RdbAdapter adapter;
    private Map<String, RdbAdapter> adapterMap;

    public RdbAdapter getRdbAdapter() {
        return this.adapter;
    }

    public RdbAdapter getRdbAdapter(String name) {
        if (name == null) {
            return this.adapter;
        }
        return this.adapterMap.get(name);
    }

    @Override
    public void destroy() {
        this.adapter = null;
        this.adapterMap = null;
    }

    @Override
    public void init(Config config) {
        this.adapterMap = new HashMap<String, RdbAdapter>();
        if (config.getNames() != null) {
            for (String name : config.getNames()) {
                if (name.equals("adapter")) {
                    this.adapter = (RdbAdapter)config.getBean("adapter");
                    continue;
                }
                this.adapterMap.put(name, (RdbAdapter)config.getBean(name));
            }
        }
        if (this.adapter == null) {
            throw new RuntimeException("adapter not specify.");
        }
        if (this.adapter instanceof NoopRdbAdapter) {
            logger.error("It is necessary to set a value other than NoopRdbAdapter to adapter.");
        }
    }
}

