/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.common.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.AggregateFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class CountFunctionAdapter
extends AggregateFunctionAdapter<Count> {
    public CountFunctionAdapter() {
        super("COUNT", Long.class);
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Count function, RdbAdapter rdb) {
        if (function.getValue() == null) {
            context.append("COUNT(*)");
        } else {
            context.append("COUNT(");
            if (function.isDistinct()) {
                context.append("DISTINCT ");
            }
            context.appendArgument(function.getValue());
            context.append(")");
        }
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args == null || args.size() == 0) {
            context.append("COUNT(*)");
        } else if (args.size() == 1) {
            context.append("COUNT(");
            context.append(args.get(0));
            context.append(")");
        } else if (args.size() == 2) {
            context.append("COUNT(");
            context.append(args.get(0));
            context.append(" ");
            context.append(args.get(1));
            context.append(")");
        } else {
            throw new QueryException("COUNT argment mismatch.");
        }
    }
}

