/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.iplass.mtp.impl.rdb.connection.ConnectionException;
import org.iplass.mtp.impl.rdb.connection.DataSourceConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.ReplicationAwareConnection;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationAwareDataSourceConnectionFactory
extends DataSourceConnectionFactory {
    private static Logger logger = LoggerFactory.getLogger(ReplicationAwareDataSourceConnectionFactory.class);
    private List<DataSource> replicaDataSource;
    private boolean directCreate;
    private Random rand = new Random();

    public List<DataSource> getReplicaDataSource() {
        return this.replicaDataSource;
    }

    @Override
    public void init(Config config) {
        super.init(config);
        this.replicaDataSource = config.getValues("replicaDataSource", DataSource.class);
        if (this.replicaDataSource != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("create replocaDataSource directly. DataSource:" + this.replicaDataSource);
            }
            this.directCreate = true;
        } else if (config.getValues("replicaDataSourceName") != null) {
            List<String> replicaDataSourceName = config.getValues("replicaDataSourceName");
            if (logger.isDebugEnabled()) {
                logger.debug("look up replicaDataSource from JNDI. name:" + replicaDataSourceName);
            }
            InitialContext context = null;
            try {
                this.replicaDataSource = new ArrayList<DataSource>();
                context = this.getInitialContext();
                for (String rdsn : replicaDataSourceName) {
                    this.replicaDataSource.add((DataSource)context.lookup(rdsn));
                }
            }
            catch (NamingException e) {
                throw new ConnectionException("can not create replicaDataSource:" + replicaDataSourceName, e);
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        logger.warn("InitialContext.close() fail.maybe leak... " + e, (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.directCreate && this.replicaDataSource != null) {
            for (DataSource rds : this.replicaDataSource) {
                try {
                    if (rds instanceof Closeable) {
                        ((Closeable)((Object)rds)).close();
                        continue;
                    }
                    if (!(rds instanceof AutoCloseable)) continue;
                    ((AutoCloseable)((Object)rds)).close();
                }
                catch (Exception e) {
                    logger.warn("error in ReplicationAwareDataSourceConnectionFactory#destroy()" + e, (Throwable)e);
                }
            }
        }
        this.replicaDataSource = null;
    }

    @Override
    Connection getPhysicalConnection(Function<Connection, Connection> afterGetPhysicalConnectionHandler) {
        ReplicationAwareConnection con = new ReplicationAwareConnection(this, afterGetPhysicalConnectionHandler);
        if (logger.isDebugEnabled()) {
            logger.debug("create physical connection:" + con);
        }
        return con;
    }

    protected Connection getReplicaConnectionInternal() {
        DataSource target = null;
        if (this.replicaDataSource != null && this.replicaDataSource.size() > 0) {
            int i = this.replicaDataSource.size() == 1 ? 0 : this.rand.nextInt(this.replicaDataSource.size());
            if (logger.isDebugEnabled()) {
                logger.debug("get connection from replicaDataSource[" + i + "]");
            }
            target = this.replicaDataSource.get(i);
        }
        if (target == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("replicaDataSource not defined, so fallback to default dataSource.");
            }
            target = this.getDataSource();
        }
        try {
            return target.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionException("can not get ReplicaDataSource Connection:", e);
        }
    }

    @Override
    protected boolean isCreateConnectionIfReadOnlyTransactionDefaultValue() {
        return true;
    }
}

