/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.mysql.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.aggregate.Listagg;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroupSortSpec;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.ListaggFunctionAdapter;

public class MySqlListaggFunctionAdapter
extends ListaggFunctionAdapter {
    public MySqlListaggFunctionAdapter() {
        this.setSqlFunctionName("GROUP_CONCAT");
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Listagg function, RdbAdapter rdb) {
        context.append("GROUP_CONCAT(");
        if (function.isDistinct()) {
            context.append("DISTINCT ");
        }
        context.appendArgument(function.getValue());
        if (function.getWithinGroup() != null) {
            context.append(" ORDER BY ");
            for (int i = 0; i < function.getWithinGroup().getSortSpecList().size(); ++i) {
                if (i > 0) {
                    context.append(",");
                }
                this.toOrderBySpecSQL(context, function.getWithinGroup().getSortSpecList().get(i));
            }
        }
        if (function.getSeparator() != null) {
            context.append(" SEPARATOR ");
            context.appendArgument(function.getSeparator());
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(" SEPARATOR '");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        context.append(")");
    }

    @Override
    protected void toOrderBySpecSQL(FunctionAdapter.FunctionContext context, WithinGroupSortSpec ss) {
        if (ss.getNullOrderingSpec() != null) {
            context.appendArgument(ss.getSortKey());
            switch (ss.getNullOrderingSpec()) {
                case FIRST: {
                    context.append(" IS NULL DESC,");
                    break;
                }
                case LAST: {
                    context.append(" IS NULL ASC,");
                    break;
                }
            }
        }
        context.appendArgument(ss.getSortKey());
        if (ss.getType() != null) {
            switch (ss.getType()) {
                case ASC: {
                    context.append(" ASC");
                    break;
                }
                case DESC: {
                    context.append(" DESC");
                    break;
                }
            }
        }
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args.size() != 4) {
            throw new QueryException("LISTAGG argment mismatch.");
        }
        context.append("GROUP_CONCAT(");
        if (args.get(0) != null) {
            context.append(args.get(0));
            context.append(" ");
        }
        context.append(args.get(1));
        if (args.get(3) != null) {
            context.append(" ORDER BY ");
            context.append(args.get(3));
        }
        if (args.get(2) != null) {
            context.append(" SEPARATOR '");
            context.append(args.get(2));
            context.append("'");
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(" SEPARATOR '");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        context.append(")");
    }
}

