/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.oracle;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class OracleDateRdbTypeAdapter
extends BaseRdbTypeAdapter.Date {
    public OracleDateRdbTypeAdapter(PropertyType propertyType) {
        super(propertyType);
    }

    @Override
    public void setParameter(int index, Object javaTypeValue, PreparedStatement stmt, RdbAdapter rdb) throws SQLException {
        Date val = this.toRdb(javaTypeValue, rdb);
        if (val != null) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = fmt.format(val);
            stmt.setString(index, dateStr);
        } else {
            stmt.setString(index, null);
        }
    }

    @Override
    public void appendParameterPlaceholder(StringBuilder context, RdbAdapter rdb) {
        context.append("TO_DATE(?,'YYYY-MM-DD')");
    }
}

