/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.oracle;

import java.sql.SQLException;
import java.sql.Statement;
import org.iplass.mtp.impl.rdb.adapter.MultiInsertContext;

public class OracleMultiInsertContext
extends MultiInsertContext {
    private StringBuilder sb = new StringBuilder();
    private boolean isInsert;

    public OracleMultiInsertContext(Statement stmt) {
        super(stmt);
        this.sb.append("INSERT ALL ");
        this.isInsert = false;
    }

    @Override
    public void addInsertSql(String sql) throws SQLException {
        if (sql.regionMatches(true, 0, "INSERT", 0, 6)) {
            this.sb.append(sql.substring(6));
            this.sb.append(" ");
            this.isInsert = true;
        } else {
            super.addInsertSql(sql);
        }
    }

    @Override
    public int[] execute() throws SQLException {
        if (this.isInsert) {
            this.sb.append(" SELECT 1 FROM DUAL");
            super.addInsertSql(this.sb.toString());
        }
        return super.execute();
    }

    @Override
    public boolean isSqlAdded() {
        if (this.isInsert) {
            return true;
        }
        return super.isSqlAdded();
    }
}

