/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.oracle.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.DateTimeUnit;
import org.iplass.mtp.impl.rdb.oracle.OracleRdbAdapter;

public class OracleDateDiffFunctionAdapter
implements FunctionAdapter<Function>,
DateTimeUnit {
    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        if (function.getArguments() == null || function.getArguments().size() != 3) {
            throw new QueryException(function.getName() + " must have 3 arguments.");
        }
        String unit = ((String)((Literal)function.getArguments().get(0)).getValue()).toUpperCase();
        context.append("TRUNC(");
        switch (unit) {
            case "YEAR": {
                context.append(((OracleRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.appendArgument(function.getArguments().get(2));
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(")/12");
                break;
            }
            case "MONTH": {
                context.append(((OracleRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.appendArgument(function.getArguments().get(2));
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(")");
                break;
            }
            case "DAY": {
                context.append("CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS DATE)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS DATE)");
                break;
            }
            case "HOUR": {
                context.append("(CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS DATE)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS DATE))*24");
                break;
            }
            case "MINUTE": {
                context.append("(CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS DATE)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS DATE))*1440");
                break;
            }
            case "SECOND": {
                context.append("(CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS DATE)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS DATE))*86400");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args == null || args.size() != 3) {
            throw new QueryException(this.getFunctionName() + " must have 3 arguments.");
        }
        String unit = args.get(0).toString().toUpperCase();
        context.append("TRUNC(");
        switch (unit) {
            case "YEAR": {
                context.append(((OracleRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append(args.get(2));
                context.append(",");
                context.append(args.get(1));
                context.append(")/12");
                break;
            }
            case "MONTH": {
                context.append(((OracleRdbAdapter)rdb).getMonthsBetweenFunction());
                context.append("(");
                context.append(args.get(2));
                context.append(",");
                context.append(args.get(1));
                context.append(")");
                break;
            }
            case "DAY": {
                context.append("CAST((");
                context.append(args.get(2));
                context.append(") AS DATE)-CAST((");
                context.append(args.get(1));
                context.append(") AS DATE)");
                break;
            }
            case "HOUR": {
                context.append("(CAST((");
                context.append(args.get(2));
                context.append(") AS DATE)-CAST((");
                context.append(args.get(1));
                context.append(") AS DATE))*24");
                break;
            }
            case "MINUTE": {
                context.append("(CAST((");
                context.append(args.get(2));
                context.append(") AS DATE)-CAST((");
                context.append(args.get(1));
                context.append(") AS DATE))*1440");
                break;
            }
            case "SECOND": {
                context.append("(CAST((");
                context.append(args.get(2));
                context.append(") AS DATE)-CAST((");
                context.append(args.get(1));
                context.append(") AS DATE))*86400");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return "DATE_DIFF";
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Long.class;
    }
}

