/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.postgresql.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.aggregate.Listagg;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.ListaggFunctionAdapter;

public class PostgreSQLListaggFunctionAdapter
extends ListaggFunctionAdapter {
    public PostgreSQLListaggFunctionAdapter() {
        this.setSqlFunctionName("STRING_AGG");
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Listagg function, RdbAdapter rdb) {
        context.append("STRING_AGG(");
        if (function.isDistinct()) {
            context.append("DISTINCT ");
        }
        context.appendArgument(function.getValue());
        if (function.getSeparator() != null) {
            context.append(",");
            context.appendArgument(function.getSeparator());
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(",'");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        if (function.getWithinGroup() != null) {
            context.append(" ORDER BY ");
            for (int i = 0; i < function.getWithinGroup().getSortSpecList().size(); ++i) {
                if (i > 0) {
                    context.append(",");
                }
                this.toOrderBySpecSQL(context, function.getWithinGroup().getSortSpecList().get(i));
            }
        }
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args.size() != 4) {
            throw new QueryException("LISTAGG argment mismatch.");
        }
        context.append("STRING_AGG(");
        if (args.get(0) != null) {
            context.append(args.get(0));
            context.append(" ");
        }
        context.append(args.get(1));
        if (args.get(2) != null) {
            context.append(",'");
            context.append(args.get(2));
            context.append("'");
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(",'");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        if (args.get(3) != null) {
            context.append(" ORDER BY ");
            context.append(args.get(3));
            context.append(")");
        }
    }
}

