/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.postgresql.function;

import java.util.List;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.RoundTruncFunctionAdapter;

public class PostgreSQLRoundTruncFunctionAdapter
extends RoundTruncFunctionAdapter {
    private String sqlFunctionName;

    public PostgreSQLRoundTruncFunctionAdapter(String funcName, String sqlFuncName) {
        super(funcName, sqlFuncName);
        this.sqlFunctionName = sqlFuncName;
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        context.append(this.sqlFunctionName);
        context.append("(");
        if (function.getArguments() != null) {
            for (int i = 0; i < function.getArguments().size(); ++i) {
                if (i != 0) {
                    context.append(",");
                }
                context.appendArgument(function.getArguments().get(i));
                if (i != 0) continue;
                context.append("::numeric");
            }
        }
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        context.append(this.sqlFunctionName);
        context.append("(");
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    context.append(",");
                }
                context.append(args.get(i));
                if (i != 0) continue;
                context.append("::numeric");
            }
        }
        context.append(")");
    }
}

