/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.sql.Timestamp;
import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.DateTimeUnit;
import org.iplass.mtp.impl.rdb.sqlserver.SqlServerRdbAdapter;

public class SqlServerDateAddFunctionAdapter
implements FunctionAdapter<Function>,
DateTimeUnit {
    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        String unit;
        if (function.getArguments() == null || function.getArguments().size() != 3) {
            throw new QueryException(function.getName() + " must have 3 arguments.");
        }
        switch (unit = ((String)((Literal)function.getArguments().get(2)).getValue()).toUpperCase()) {
            case "YEAR": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(year,");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(0));
                context.append(")");
                break;
            }
            case "MONTH": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(month,");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(0));
                context.append(")");
                break;
            }
            case "DAY": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(day,");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(0));
                context.append(")");
                break;
            }
            case "HOUR": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(hour,");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(0));
                context.append(")");
                break;
            }
            case "MINUTE": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(minute,");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(0));
                context.append(")");
                break;
            }
            case "SECOND": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(second,");
                context.appendArgument(function.getArguments().get(1));
                context.append(",");
                context.appendArgument(function.getArguments().get(0));
                context.append(")");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        String unit;
        if (args == null || args.size() != 3) {
            throw new QueryException(this.getFunctionName() + " must have 3 arguments.");
        }
        switch (unit = args.get(2).toString().toUpperCase()) {
            case "YEAR": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(year,");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(0));
                context.append(")");
                break;
            }
            case "MONTH": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(month,");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(0));
                context.append(")");
                break;
            }
            case "DAY": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(day,");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(0));
                context.append(")");
                break;
            }
            case "HOUR": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(hour,");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(0));
                context.append(")");
                break;
            }
            case "MINUTE": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(minute,");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(0));
                context.append(")");
                break;
            }
            case "SECOND": {
                context.append(((SqlServerRdbAdapter)rdb).getAddMonthsFunction());
                context.append("(second,");
                context.append(args.get(1));
                context.append(",");
                context.append(args.get(0));
                context.append(")");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
    }

    @Override
    public String getFunctionName() {
        return "DATE_ADD";
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Timestamp.class;
    }
}

