/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.aggregate.Listagg;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroupSortSpec;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.ListaggFunctionAdapter;

public class SqlServerListaggFunctionAdapter
extends ListaggFunctionAdapter {
    public SqlServerListaggFunctionAdapter() {
        this.setSqlFunctionName("STRING_AGG");
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Listagg function, RdbAdapter rdb) {
        context.append("STRING_AGG(");
        context.appendArgument(function.getValue());
        if (function.getSeparator() != null) {
            context.append(",");
            context.appendArgument(function.getSeparator());
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(",'");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        context.append(")");
        this.toWithinGroupSQL(context, function.getWithinGroup());
    }

    @Override
    protected void toOrderBySpecSQL(FunctionAdapter.FunctionContext context, WithinGroupSortSpec ss) {
        if (ss.getNullOrderingSpec() != null) {
            switch (ss.getNullOrderingSpec()) {
                case FIRST: {
                    context.append("CASE WHEN ");
                    context.appendArgument(ss.getSortKey());
                    context.append(" IS NULL THEN 0 ELSE 1 END ASC, ");
                    break;
                }
                case LAST: {
                    context.append("CASE WHEN ");
                    context.appendArgument(ss.getSortKey());
                    context.append(" IS NULL THEN 0 ELSE 1 END DESC, ");
                    break;
                }
            }
        }
        context.appendArgument(ss.getSortKey());
        if (ss.getType() != null) {
            switch (ss.getType()) {
                case ASC: {
                    context.append(" ASC");
                    break;
                }
                case DESC: {
                    context.append(" DESC");
                    break;
                }
            }
        }
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args.size() != 4) {
            throw new QueryException("LISTAGG argment mismatch.");
        }
        context.append("STRING_AGG(");
        context.append(args.get(1));
        if (args.get(2) != null) {
            context.append(",'");
            context.append(args.get(2));
            context.append("'");
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(",'");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        context.append(")");
        if (args.get(3) != null) {
            context.append(" WITHIN GROUP(ORDER BY ");
            context.append(args.get(3));
            context.append(")");
        }
    }
}

