/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.util.List;
import java.util.function.Consumer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class SqlServerSubstrFunctionAdapter
implements FunctionAdapter<Function> {
    private static final int INDEX_STR = 0;
    private static final int INDEX_IDX = 1;
    private static final int INDEX_LN = 2;
    private String field;

    public SqlServerSubstrFunctionAdapter(String field) {
        this.field = field;
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        if (function.getArguments() == null || function.getArguments().size() < 2 || function.getArguments().size() > 3) {
            throw new QueryException(function.getName() + " must have two or three arguments.");
        }
        this.buildSql(context::append, context::appendArgument, function.getArguments());
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args == null || args.size() < 2 || args.size() > 3) {
            throw new QueryException(this.getFunctionName() + " must have two or three arguments.");
        }
        this.buildSql(context::append, context::append, args);
    }

    @Override
    public String getFunctionName() {
        return this.field;
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return String.class;
    }

    private <T> void buildSql(Consumer<String> appendString, Consumer<T> appendArg, List<T> args) {
        if (args.size() == 3) {
            appendString.accept("CASE WHEN 0 <= ");
            appendArg.accept(args.get(1));
            appendString.accept(" THEN SUBSTRING(");
            appendArg.accept(args.get(0));
            appendString.accept(",");
            appendArg.accept(args.get(1));
            appendString.accept(",");
            appendArg.accept(args.get(2));
            appendString.accept(") ELSE LEFT(RIGHT(");
            appendArg.accept(args.get(0));
            appendString.accept(",ABS(");
            appendArg.accept(args.get(1));
            appendString.accept(")),");
            appendArg.accept(args.get(2));
            appendString.accept(") END");
        } else {
            appendString.accept("CASE WHEN 0 <= ");
            appendArg.accept(args.get(1));
            appendString.accept(" THEN SUBSTRING(");
            appendArg.accept(args.get(0));
            appendString.accept(",");
            appendArg.accept(args.get(1));
            appendString.accept(",LEN(");
            appendArg.accept(args.get(0));
            appendString.accept(")) ELSE RIGHT(");
            appendArg.accept(args.get(0));
            appendString.accept(",ABS(");
            appendArg.accept(args.get(1));
            appendString.accept(")) END");
        }
    }
}

