/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.runtime;

import java.util.Map;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.runtime.RunnerImpl;
import org.iplass.mtp.runtime.AlreadyInitializedException;
import org.iplass.mtp.runtime.EntryPoint;
import org.iplass.mtp.runtime.Runner;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPointImpl
implements EntryPoint {
    private static Logger logger = LoggerFactory.getLogger(EntryPointImpl.class);
    private static volatile EntryPointImpl instance;
    private ServiceRegistry serviceRegistry = ServiceRegistry.getRegistry();

    public static boolean isInited() {
        return instance != null;
    }

    public static EntryPointImpl getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EntryPointImpl newEntryPointImpl(Map<String, String> customProps) {
        Class<EntryPointImpl> clazz = EntryPointImpl.class;
        synchronized (EntryPointImpl.class) {
            if (instance != null) {
                throw new AlreadyInitializedException("EntryPoint already initialized");
            }
            try {
                if (!BootstrapProps.init(customProps)) {
                    logger.warn("BootstrapProps already initialized, so can not apply customProps:" + customProps);
                }
                instance = new EntryPointImpl();
            }
            finally {
                ExecuteContext.finContext();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private EntryPointImpl() {
    }

    @Override
    public Runner runner() {
        return new RunnerImpl(this.serviceRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Class<EntryPointImpl> clazz = EntryPointImpl.class;
        synchronized (EntryPointImpl.class) {
            if (instance == this) {
                instance = null;
                this.serviceRegistry.destroyAllService();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

