/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.runtime;

import java.util.function.Supplier;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.command.CommandInvoker;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.runtime.Runner;
import org.iplass.mtp.spi.ServiceRegistry;

public class RunnerImpl
implements Runner {
    private ServiceRegistry sr;
    private String tenantUrl;
    private Integer tenantId;
    private Credential credential;
    private String lang;

    RunnerImpl(ServiceRegistry sr) {
        this.sr = sr;
    }

    @Override
    public Runner withTenant(String tenantUrl) {
        this.tenantUrl = tenantUrl;
        this.tenantId = null;
        return this;
    }

    @Override
    public Runner withTenant(Integer tenantId) {
        this.tenantId = tenantId;
        this.tenantUrl = null;
        return this;
    }

    @Override
    public Runner withAuth(Credential credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public Runner withLang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public void run(Runnable r) {
        this.run(() -> {
            r.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Supplier<T> s) {
        TenantContextService tcs = this.sr.getService(TenantContextService.class);
        TenantContext tc = null;
        if (this.tenantUrl != null) {
            tc = tcs.getTenantContext(this.tenantUrl);
            if (tc == null) {
                throw new SystemException("tenant not found:tenantUrl=" + this.tenantUrl);
            }
        } else if (this.tenantId != null) {
            tc = tcs.getTenantContext(this.tenantId);
            if (tc == null) {
                throw new SystemException("tenant not found:tenantId=" + this.tenantId);
            }
        } else {
            tc = tcs.getTenantContext(tcs.getSharedTenantId());
        }
        try {
            ExecuteContext ec = new ExecuteContext(tc);
            ExecuteContext.initContext(new ExecuteContext(tc));
            if (this.lang != null) {
                ec.setLanguage(this.lang);
            }
            if (this.credential == null) {
                T t = s.get();
                return t;
            }
            AuthService as = this.sr.getService(AuthService.class);
            as.login(this.credential);
            Object object = as.doSecuredAction(AuthContextHolder.getAuthContext(), () -> s.get());
            return (T)object;
        }
        finally {
            ExecuteContext.finContext();
        }
    }

    @Override
    public String run(String commandName, RequestContext request) {
        return this.run(() -> {
            CommandInvoker invoker = ManagerLocator.manager(CommandInvoker.class);
            return invoker.execute(commandName, request);
        });
    }
}

