/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import org.codehaus.groovy.GroovyBugError;
import org.iplass.mtp.impl.script.GroovyScriptContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptRuntimeException;

public class GroovyScript
implements Script {
    static final String CODE_BASE = "/groovy/script";
    private Class<?> cls;

    public GroovyScript(GroovyClassLoader classLoader, String script, String name) {
        try {
            GroovyCodeSource codeSource = new GroovyCodeSource(script, name + ".groovy", CODE_BASE);
            codeSource.setCachable(false);
            this.cls = classLoader.parseClass(codeSource);
        }
        catch (NoClassDefFoundError | GroovyBugError e) {
            throw new ScriptRuntimeException(e);
        }
    }

    @Override
    public <T> T createInstanceAs(Class<T> type, ScriptContext context) {
        try {
            if (type.isAssignableFrom(this.cls)) {
                return (T)this.cls.newInstance();
            }
            throw new ScriptRuntimeException(this.cls.getName() + " is not implimentation class or subclass of " + type);
        }
        catch (InstantiationException e) {
            throw new ScriptRuntimeException("can not instantiate " + this.cls.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ScriptRuntimeException("can not instantiate " + this.cls.getName(), e);
        }
    }

    @Override
    public Object eval(ScriptContext context) {
        try {
            if (groovy.lang.Script.class.isAssignableFrom(this.cls)) {
                groovy.lang.Script gScript = (groovy.lang.Script)this.cls.newInstance();
                gScript.setBinding(((GroovyScriptContext)context).getBinding());
                return gScript.run();
            }
            throw new ScriptRuntimeException(this.cls.getName() + " is not Script.");
        }
        catch (InstantiationException e) {
            throw new ScriptRuntimeException("can not instantiate " + this.cls.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ScriptRuntimeException("can not instantiate " + this.cls.getName(), e);
        }
    }

    @Override
    public boolean isInstantiateAs(Class<?> type) {
        return type.isAssignableFrom(this.cls);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

