/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantMailInfo;
import org.iplass.mtp.util.StringUtil;

public class MetaTenantMailInfo
extends MetaTenantConfig<TenantMailInfo> {
    private static final long serialVersionUID = -6973970284964999243L;
    private boolean sendMailEnable;
    private String mailFrom;
    private String mailFromName;
    private String mailReply;
    private String mailReplyName;

    public boolean isSendMailEnable() {
        return this.sendMailEnable;
    }

    public void setSendMailEnable(boolean sendMailEnable) {
        this.sendMailEnable = sendMailEnable;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getMailFromName() {
        return this.mailFromName;
    }

    public void setMailFromName(String mailFromName) {
        this.mailFromName = mailFromName;
    }

    public String getMailReply() {
        return this.mailReply;
    }

    public void setMailReply(String mailReply) {
        this.mailReply = mailReply;
    }

    public String getMailReplyName() {
        return this.mailReplyName;
    }

    public void setMailReplyName(String mailReplyName) {
        this.mailReplyName = mailReplyName;
    }

    @Override
    public MetaData copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(TenantMailInfo definition) {
        this.setSendMailEnable(definition.isSendMailEnable());
        this.setMailFrom(definition.getMailFrom());
        this.setMailFromName(definition.getMailFromName());
        this.setMailReply(definition.getMailReply());
        this.setMailReplyName(definition.getMailReplyName());
    }

    @Override
    public TenantMailInfo currentConfig() {
        TenantMailInfo definition = new TenantMailInfo();
        definition.setSendMailEnable(this.isSendMailEnable());
        definition.setMailFrom(this.getMailFrom());
        definition.setMailFromName(this.getMailFromName());
        definition.setMailReply(this.getMailReply());
        definition.setMailReplyName(this.getMailReplyName());
        return definition;
    }

    @Override
    public MetaTenantMailInfoRuntime createRuntime(MetaTenant.MetaTenantHandler tenantRuntime) {
        return new MetaTenantMailInfoRuntime();
    }

    public class MetaTenantMailInfoRuntime
    extends MetaTenantConfig.MetaTenantConfigRuntime {
        private String defaultMailFrom;
        private String defaultMailFromName;

        public MetaTenantMailInfoRuntime() {
            TenantContextService tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
            this.defaultMailFrom = tcService.getDefaultMailFrom();
            this.defaultMailFromName = tcService.getDefaultMailFromName();
        }

        @Override
        public MetaData getMetaData() {
            return MetaTenantMailInfo.this;
        }

        @Override
        public void applyMetaDataToTenant(Tenant tenant) {
            TenantMailInfo mail = tenant.getTenantConfig(TenantMailInfo.class);
            if (mail != null && StringUtil.isEmpty(mail.getMailFrom())) {
                mail.setMailFrom(this.defaultMailFrom);
                mail.setMailFromName(this.defaultMailFromName);
            }
        }
    }
}

