/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import org.iplass.mtp.definition.DefinitionModifyResult;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.AbstractTypedDefinitionManager;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantManagerImpl
extends AbstractTypedDefinitionManager<Tenant>
implements TenantManager {
    private static final Logger logger = LoggerFactory.getLogger(TenantManagerImpl.class);
    private TenantService tenantService = ServiceRegistry.getRegistry().getService(TenantService.class);
    private MetaTenantService metaTenantService = ServiceRegistry.getRegistry().getService(MetaTenantService.class);

    @Override
    public Tenant getTenant() {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        Tenant tenant = this.tenantService.getTenant(tenantId);
        if (tenant == null) {
            return null;
        }
        MetaTenant.MetaTenantHandler handler = this.metaTenantService.getRuntimeByName(tenant.getName());
        if (handler == null) {
            return null;
        }
        MetaTenant metaTenant = handler.getMetaData();
        metaTenant.applyToTenant(tenant);
        return tenant;
    }

    @Override
    public Tenant get(String definitionName) {
        return this.getTenant();
    }

    @Override
    public DefinitionModifyResult updateTenant(Tenant tenant) {
        return this.updateTenant(tenant, false);
    }

    @Override
    public DefinitionModifyResult updateTenant(Tenant tenant, boolean forceUpdate) {
        Tenant oldTenant = this.tenantService.getTenant(tenant.getId());
        if (oldTenant == null) {
            logger.error("exception occured during tenant definition update:\u6307\u5b9a\u306e\u30c6\u30ca\u30f3\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30c6\u30ca\u30f3\u30c8ID=" + tenant.getId());
            return new DefinitionModifyResult(false, "exception occured during tenant definition update:\u6307\u5b9a\u306e\u30c6\u30ca\u30f3\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30c6\u30ca\u30f3\u30c8ID=" + tenant.getId());
        }
        MetaTenant.MetaTenantHandler handler = this.metaTenantService.getRuntimeByName(oldTenant.getName());
        if (handler == null) {
            logger.error("exception occured during tenant definition update:\u6307\u5b9a\u306e\u30c6\u30ca\u30f3\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30c6\u30ca\u30f3\u30c8\u540d=" + oldTenant.getName());
            return new DefinitionModifyResult(false, "exception occured during tenant definition update:\u6307\u5b9a\u306e\u30c6\u30ca\u30f3\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30c6\u30ca\u30f3\u30c8\u540d=" + oldTenant.getName());
        }
        MetaTenant updateMetaTenant = new MetaTenant(tenant);
        updateMetaTenant.setId(handler.getMetaData().getId());
        try {
            String clientId = ExecuteContext.getCurrentContext().getClientId();
            this.tenantService.updateTenant(tenant, clientId, forceUpdate);
            this.metaTenantService.updateMetaData(updateMetaTenant);
            tenant = this.tenantService.getTenant(tenant.getId());
        }
        catch (Exception e) {
            this.setRollbackOnly();
            if (e.getCause() != null) {
                logger.error("exception occured during tenant definition update:" + e.getCause().getMessage(), e.getCause());
                return new DefinitionModifyResult(false, "exception occured during tenant definition update:" + e.getCause().getMessage());
            }
            logger.error("exception occured during tenant definition update:" + e.getMessage(), (Throwable)e);
            return new DefinitionModifyResult(false, "exception occured during tenant definition update:" + e.getMessage());
        }
        return new DefinitionModifyResult(true);
    }

    @Override
    public DefinitionModifyResult update(Tenant definition) {
        return this.updateTenant(definition);
    }

    @Override
    public Class<Tenant> getDefinitionType() {
        return Tenant.class;
    }

    @Override
    protected RootMetaData newInstance(Tenant definition) {
        return new MetaTenant();
    }

    @Override
    protected TypedMetaDataService getService() {
        return this.metaTenantService;
    }
}

