/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant.rdb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.impl.tenant.TenantStore;
import org.iplass.mtp.impl.tenant.rdb.TenantControlSQL;
import org.iplass.mtp.impl.tenant.rdb.TenantSelectSQL;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;

public class RdbTenantStore
implements TenantStore {
    private String connectionFactoryName;
    private String rdbAdapterName;
    private RdbAdapter rdb;
    private TenantSelectSQL tenantSelect;
    private TenantControlSQL tenantControl;

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getRdbAdapterName() {
        return this.rdbAdapterName;
    }

    public void setRdbAdapterName(String rdbAdapterName) {
        this.rdbAdapterName = rdbAdapterName;
    }

    @Override
    public void inited(TenantService service, Config config) {
        this.rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter(this.rdbAdapterName);
        this.tenantSelect = this.rdb.getQuerySqlCreator(TenantSelectSQL.class);
        this.tenantControl = this.rdb.getUpdateSqlCreator(TenantControlSQL.class);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public Tenant getTenant(final String url) {
        SqlExecuter<Tenant> exec = new SqlExecuter<Tenant>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Tenant logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbTenantStore.this.tenantSelect.createSQL(url));
                RdbTenantStore.this.tenantSelect.setParameter(RdbTenantStore.this.rdb, ps, url);
                try (ResultSet rs = ps.executeQuery();){
                    Tenant tenant = RdbTenantStore.this.tenantSelect.createTenant(rs, RdbTenantStore.this.rdb);
                    return tenant;
                }
            }
        };
        return (Tenant)exec.execute(this.connectionFactoryName, this.rdb, true);
    }

    @Override
    public Tenant getTenant(final int id) {
        SqlExecuter<Tenant> exec = new SqlExecuter<Tenant>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Tenant logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbTenantStore.this.tenantSelect.createSQL());
                RdbTenantStore.this.tenantSelect.setParameter(RdbTenantStore.this.rdb, ps, id);
                try (ResultSet rs = ps.executeQuery();){
                    Tenant tenant = RdbTenantStore.this.tenantSelect.createTenant(rs, RdbTenantStore.this.rdb);
                    return tenant;
                }
            }
        };
        return (Tenant)exec.execute(this.connectionFactoryName, this.rdb, true);
    }

    @Override
    public void registTenant(final Tenant tenant, final String registId) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbTenantStore.this.tenantControl.createRegistSQL(RdbTenantStore.this.rdb));
                RdbTenantStore.this.tenantControl.setRegistParameter(RdbTenantStore.this.rdb, ps, tenant, registId);
                ps.executeUpdate();
                return null;
            }
        };
        executer.execute(this.connectionFactoryName, this.rdb, true);
    }

    @Override
    public void updateTenant(final Tenant tenant, final String updateId, final boolean forceUpdate) {
        SqlExecuter<Void> executer = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbTenantStore.this.tenantControl.createUpdateSQL(RdbTenantStore.this.rdb, forceUpdate));
                RdbTenantStore.this.tenantControl.setUpdateParameter(RdbTenantStore.this.rdb, ps, tenant, updateId, forceUpdate);
                int cnt = ps.executeUpdate();
                if (cnt == 0) {
                    throw new RuntimeException("\u3059\u3067\u306b\u66f4\u65b0\u3055\u308c\u3066\u3044\u308b\u304b\u3001\u524a\u9664\u3055\u308c\u3066\u3044\u308b");
                }
                return null;
            }
        };
        executer.execute(this.connectionFactoryName, this.rdb, true);
    }

    @Override
    public List<Integer> getAllTenantIdList() {
        SqlExecuter<List<Integer>> exec = new SqlExecuter<List<Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Integer> logic() throws SQLException {
                PreparedStatement ps = this.getPreparedStatement(RdbTenantStore.this.tenantSelect.createAllTenantIdListSQL());
                RdbTenantStore.this.tenantSelect.setAllTenantIdListParameter(RdbTenantStore.this.rdb, ps);
                try (ResultSet rs = ps.executeQuery();){
                    List<Integer> list = RdbTenantStore.this.tenantSelect.getAllTenantIdList(rs);
                    return list;
                }
            }
        };
        return (List)exec.execute(this.connectionFactoryName, this.rdb, true);
    }
}

