/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant.rdb;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.tenant.Tenant;

public class TenantSelectSQL
extends QuerySqlHandler {
    public static final String COLUMNS = "ID, NAME, DESCRIPTION, URL, YUKO_DATE_FROM, YUKO_DATE_TO, CRE_USER, CRE_DATE, UP_USER, UP_DATE";

    public String createSQL() {
        return "SELECT ID, NAME, DESCRIPTION, URL, YUKO_DATE_FROM, YUKO_DATE_TO, CRE_USER, CRE_DATE, UP_USER, UP_DATE FROM T_TENANT WHERE ID = ? AND YUKO_DATE_FROM <= ? AND YUKO_DATE_TO >= ?";
    }

    public void setParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId) throws SQLException {
        Date now = InternalDateUtil.getNowForSqlDate();
        int index = 1;
        ps.setInt(index++, tenantId);
        ps.setDate(index++, now);
        ps.setDate(index++, now);
    }

    public String createSQL(String url) {
        if (url.length() == 0) {
            return "SELECT ID, NAME, DESCRIPTION, URL, YUKO_DATE_FROM, YUKO_DATE_TO, CRE_USER, CRE_DATE, UP_USER, UP_DATE FROM T_TENANT WHERE URL IS NULL AND YUKO_DATE_FROM <= ? AND YUKO_DATE_TO >= ?";
        }
        return "SELECT ID, NAME, DESCRIPTION, URL, YUKO_DATE_FROM, YUKO_DATE_TO, CRE_USER, CRE_DATE, UP_USER, UP_DATE FROM T_TENANT WHERE URL = ? AND YUKO_DATE_FROM <= ? AND YUKO_DATE_TO >= ?";
    }

    public void setParameter(RdbAdapter rdb, PreparedStatement ps, String url) throws SQLException {
        Date now = InternalDateUtil.getNowForSqlDate();
        int index = 1;
        if (url.length() > 0) {
            ps.setString(index++, url);
        }
        ps.setDate(index++, now);
        ps.setDate(index++, now);
    }

    public Tenant createTenant(ResultSet rs, RdbAdapter rdb) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        Tenant tenant = new Tenant();
        tenant.setId(rs.getInt("ID"));
        tenant.setName(rs.getString("NAME"));
        tenant.setDescription(rs.getString("DESCRIPTION"));
        String url = rs.getString("URL");
        tenant.setUrl(url == null ? "" : url);
        tenant.setFrom(rs.getDate("YUKO_DATE_FROM", rdb.javaCalendar()));
        tenant.setTo(rs.getDate("YUKO_DATE_TO", rdb.javaCalendar()));
        tenant.setCreateUser(rs.getString("CRE_USER"));
        tenant.setCreateDate(rs.getTimestamp("CRE_DATE", rdb.rdbCalendar()));
        tenant.setUpdateUser(rs.getString("UP_USER"));
        tenant.setUpdateDate(rs.getTimestamp("UP_DATE", rdb.rdbCalendar()));
        if (rs.next()) {
            throw new IllegalStateException("Tenant\u60c5\u5831\u304c\u8907\u6570\u3042\u308a\u307e\u3059");
        }
        return tenant;
    }

    public String createAllTenantIdListSQL() {
        return "SELECT ID FROM T_TENANT WHERE YUKO_DATE_FROM <= ? AND YUKO_DATE_TO >= ?";
    }

    public void setAllTenantIdListParameter(RdbAdapter rdb, PreparedStatement ps) throws SQLException {
        Date now = InternalDateUtil.getNowForSqlDate();
        int index = 1;
        ps.setDate(index++, now);
        ps.setDate(index++, now);
    }

    public List<Integer> getAllTenantIdList(ResultSet rs) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (rs.next()) {
            list.add(rs.getInt("ID"));
        }
        return list;
    }
}

