/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.transaction;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.EntityDuplicateValueException;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.rdb.connection.LocalTransactionConnectionWrapper;
import org.iplass.mtp.impl.transaction.LocalTransactionManager;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.RollbackException;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionException;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransaction
implements Transaction {
    private static Logger logger = LoggerFactory.getLogger(LocalTransaction.class);
    private Map<Object, Object> transactionLocalAttribute;
    private List<TransactionListener> listenerList;
    private LocalTransactionConnectionWrapper con;
    private boolean rollbackOnly;
    private TransactionStatus status;
    private LocalTransaction stacked;
    private final boolean readOnly;
    private boolean finalized;
    private boolean testRollbackMode;

    public LocalTransaction(boolean readOnly) {
        this(readOnly, null);
    }

    public LocalTransaction(boolean readOnly, LocalTransaction stacked) {
        this(readOnly, stacked, false);
    }

    public LocalTransaction(boolean readOnly, LocalTransaction stacked, boolean noTransaction) {
        this.readOnly = readOnly;
        this.stacked = stacked;
        this.status = noTransaction ? TransactionStatus.NONE : TransactionStatus.ACTIVE;
        if (logger.isDebugEnabled()) {
            if (noTransaction) {
                logger.debug("set Transaction to NOT_SUPPORTED:" + this + " with stacked:" + stacked);
            } else {
                logger.debug("create new Transaction:" + this + " with readOnly=" + readOnly + ", stacked:" + stacked);
            }
        }
    }

    public LocalTransaction getStacked() {
        return this.stacked;
    }

    public LocalTransactionConnectionWrapper getCon() {
        return this.con;
    }

    public void setCon(LocalTransactionConnectionWrapper con) throws SQLException {
        if (this.finalized) {
            throw new SystemException("Current Transaction Context already finalized");
        }
        if (this.con != null) {
            throw new SystemException("LocalTransaction only support one connection per transaction.");
        }
        this.con = con;
        try {
            if (con.getAutoCommit()) {
                con.getWrapped().setAutoCommit(false);
            }
            this.con.setReadOnly(this.readOnly);
        }
        catch (SQLException e) {
            try {
                con.getWrapped().rollback();
            }
            catch (SQLException ee) {
                e.addSuppressed(ee);
            }
            try {
                con.getWrapped().close();
            }
            catch (SQLException ee) {
                e.addSuppressed(ee);
            }
            throw e;
        }
    }

    @Override
    public void commit() {
        if (this.finalized) {
            logger.warn("commit called, but this Transaction Context already finalized." + this);
            return;
        }
        if (logger.isDebugEnabled()) {
            if (this.testRollbackMode) {
                logger.debug("commit Transaction(actually rollback by test rollback mode):" + this);
            } else {
                logger.debug("commit Transaction:" + this);
            }
        }
        boolean isCommit = false;
        if (this.rollbackOnly) {
            throw new RollbackException("setRolbackOnly called");
        }
        try {
            if (this.con != null && !this.con.getWrapped().isClosed()) {
                if (this.testRollbackMode) {
                    this.con.getWrapped().rollback();
                } else {
                    this.con.getWrapped().commit();
                }
            }
            if (this.status == TransactionStatus.ACTIVE) {
                isCommit = true;
                this.status = TransactionStatus.COMMITTED;
            }
        }
        catch (RuntimeException | SQLException e) {
            this.status = TransactionStatus.NONE;
            RdbAdapter rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
            if (e instanceof SQLException && rdb.isDuplicateValueException((SQLException)e)) {
                throw new EntityDuplicateValueException(LocalTransaction.resourceString("impl.transaction.LocalTransaction.duplicate", null), e);
            }
            throw new TransactionException(e);
        }
        finally {
            if (this.con != null) {
                if (this.readOnly) {
                    try {
                        this.con.setReadOnly(false);
                    }
                    catch (SQLException e) {
                        logger.error("set ReadOnly failed at transaction commit...:" + e, (Throwable)e);
                    }
                }
                try {
                    this.con.getWrapped().setAutoCommit(true);
                }
                catch (SQLException e) {
                    logger.error("set AutoCommit failed at transaction commit...:" + e, (Throwable)e);
                }
                try {
                    this.con.closePhysical();
                }
                catch (SQLException e) {
                    logger.error("colse Connection failed at transaction commit...:" + e, (Throwable)e);
                }
            }
            this.con = null;
            this.close();
        }
        if (isCommit && this.listenerList != null) {
            for (TransactionListener l : this.listenerList) {
                l.afterCommit(this);
            }
        }
    }

    public void close() {
        if (!this.finalized) {
            if (logger.isDebugEnabled()) {
                logger.debug("close Transaction:" + this);
            }
            LocalTransactionManager.transaction.set(this.stacked);
            this.finalized = true;
        }
    }

    @Override
    public TransactionStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public void rollback() {
        if (this.finalized) {
            logger.warn("rollback called, but this Transaction Context already finalized." + this);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("rollback Transaction:" + this);
        }
        boolean isRollback = false;
        try {
            if (this.con != null && !this.con.getWrapped().isClosed()) {
                this.con.getWrapped().rollback();
            }
            if (this.status == TransactionStatus.ACTIVE) {
                isRollback = true;
                this.status = TransactionStatus.ROLLEDBACK;
            }
        }
        catch (RuntimeException | SQLException e) {
            this.status = TransactionStatus.NONE;
            throw new TransactionException(e);
        }
        finally {
            if (this.con != null) {
                if (this.readOnly) {
                    try {
                        this.con.setReadOnly(false);
                    }
                    catch (SQLException e) {
                        logger.error("set ReadOnly failed at transaction commit...:" + e, (Throwable)e);
                    }
                }
                try {
                    this.con.getWrapped().setAutoCommit(true);
                }
                catch (SQLException e) {
                    logger.error("set AutoCommit failed at transaction commit...:" + e, (Throwable)e);
                }
                try {
                    this.con.closePhysical();
                }
                catch (SQLException e) {
                    logger.error("colse Connection failed at transaction commit...:" + e, (Throwable)e);
                }
            }
            this.con = null;
            this.close();
        }
        if (isRollback && this.listenerList != null) {
            for (TransactionListener l : this.listenerList) {
                l.afterRollback(this);
            }
        }
    }

    @Override
    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public Object getAttribute(Object key) {
        if (this.transactionLocalAttribute == null) {
            return null;
        }
        return this.transactionLocalAttribute.get(key);
    }

    @Override
    public void setAttribute(Object key, Object value) {
        if (this.transactionLocalAttribute == null) {
            this.transactionLocalAttribute = new HashMap<Object, Object>();
        }
        this.transactionLocalAttribute.put(key, value);
    }

    @Override
    public Object removeAttribute(Object key) {
        if (this.transactionLocalAttribute == null) {
            return null;
        }
        return this.transactionLocalAttribute.remove(key);
    }

    @Override
    public void addTransactionListener(TransactionListener listener) {
        if (this.finalized) {
            logger.warn("Current Transaction Context already finalized. so cant add TransactionListener=" + listener);
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<TransactionListener>();
        }
        this.listenerList.add(listener);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setTestRollbackMode(boolean testRollbackMode) {
        this.testRollbackMode = testRollbackMode;
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

