/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util.random;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.codec.binary.Base32;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class SecureRandomGenerator {
    private static Base64.Encoder base64urlsafewop = Base64.getUrlEncoder().withoutPadding();
    private static Base32 base32 = new Base32();
    private final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();
    private final int numBitsOfSecureRandomToken;
    private final int radixOfSecureRandomToken;
    private final boolean useStrongSecureRandom;
    private final String algorithm;
    private final String provider;
    private final String encode;

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, boolean useStrongSecureRandom) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = useStrongSecureRandom;
        this.algorithm = null;
        this.provider = null;
        this.encode = null;
    }

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, boolean useStrongSecureRandom, String encode) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = useStrongSecureRandom;
        this.algorithm = null;
        this.provider = null;
        this.encode = encode;
    }

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, String algorithm) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = false;
        this.algorithm = algorithm;
        this.provider = null;
        this.encode = null;
    }

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, String algorithm, String provider) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = false;
        this.algorithm = algorithm;
        this.provider = provider;
        this.encode = null;
    }

    public SecureRandomGenerator(int numBitsOfSecureRandomToken, int radixOfSecureRandomToken, String algorithm, String provider, String encode) {
        this.numBitsOfSecureRandomToken = numBitsOfSecureRandomToken;
        this.radixOfSecureRandomToken = radixOfSecureRandomToken;
        this.useStrongSecureRandom = false;
        this.algorithm = algorithm;
        this.provider = provider;
        this.encode = encode;
    }

    private SecureRandom createSecureRandom() {
        try {
            SecureRandom sr = null;
            sr = this.algorithm != null ? (this.provider != null ? SecureRandom.getInstance(this.algorithm, this.provider) : SecureRandom.getInstance(this.algorithm)) : (this.useStrongSecureRandom ? SecureRandom.getInstanceStrong() : new SecureRandom());
            sr.nextInt();
            return sr;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ServiceConfigrationException("invalid secure random algorithm/provider", e);
        }
    }

    public String secureRandomToken() {
        SecureRandom rand = this.randoms.poll();
        if (rand == null) {
            rand = this.createSecureRandom();
        }
        if ("base64".equals(this.encode)) {
            int roundUpNumBytesOfSecureRandomToken = (int)Math.ceil((double)this.numBitsOfSecureRandomToken / 8.0);
            byte[] bytes = new byte[roundUpNumBytesOfSecureRandomToken];
            rand.nextBytes(bytes);
            this.randoms.add(rand);
            return base64urlsafewop.encodeToString(bytes);
        }
        if ("base32".equals(this.encode)) {
            int roundUpNumBytesOfSecureRandomToken = (int)Math.ceil((double)this.numBitsOfSecureRandomToken / 8.0);
            byte[] bytes = new byte[roundUpNumBytesOfSecureRandomToken];
            rand.nextBytes(bytes);
            this.randoms.add(rand);
            return base32.encodeToString(bytes);
        }
        if (this.radixOfSecureRandomToken == 64) {
            int roundUpNumBytesOfSecureRandomToken = (int)Math.ceil((double)this.numBitsOfSecureRandomToken / 8.0);
            byte[] bytes = new byte[roundUpNumBytesOfSecureRandomToken];
            rand.nextBytes(bytes);
            this.randoms.add(rand);
            return base64urlsafewop.encodeToString(bytes);
        }
        BigInteger randInt = new BigInteger(this.numBitsOfSecureRandomToken, rand);
        this.randoms.add(rand);
        return randInt.toString(this.radixOfSecureRandomToken);
    }

    public int randomInt(int bound) {
        SecureRandom rand = this.randoms.poll();
        if (rand == null) {
            rand = this.createSecureRandom();
        }
        int randInt = rand.nextInt(bound);
        this.randoms.add(rand);
        return randInt;
    }
}

