/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util.random;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.impl.util.random.SecureRandomGenerator;
import org.iplass.mtp.impl.util.random.SecureRandomGeneratorConfig;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class SecureRandomService
implements Service {
    public static final String DEFAULT_CONFIG_NAME = "default";
    private Map<String, SecureRandomGeneratorConfig> generatorConfigs;
    private SecureRandomGeneratorConfig defaultGeneratorConfig;

    @Override
    public void init(Config config) {
        this.generatorConfigs = new HashMap<String, SecureRandomGeneratorConfig>();
        for (String n : config.getNames()) {
            this.generatorConfigs.put(n, config.getValue(n, SecureRandomGeneratorConfig.class));
        }
        this.defaultGeneratorConfig = this.generatorConfigs.get(DEFAULT_CONFIG_NAME);
        if (this.defaultGeneratorConfig == null) {
            this.defaultGeneratorConfig = new SecureRandomGeneratorConfig();
        }
    }

    @Override
    public void destroy() {
    }

    public SecureRandomGenerator createGenerator() {
        return this.defaultGeneratorConfig.createGenerator();
    }

    public SecureRandomGenerator createGenerator(String name) {
        SecureRandomGeneratorConfig c = this.generatorConfigs.get(name);
        if (c == null) {
            c = this.defaultGeneratorConfig;
        }
        return c.createGenerator();
    }
}

