/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.validation.MetaValidationBinarySize;
import org.iplass.mtp.impl.validation.MetaValidationBinaryType;
import org.iplass.mtp.impl.validation.MetaValidationExists;
import org.iplass.mtp.impl.validation.MetaValidationJavaClass;
import org.iplass.mtp.impl.validation.MetaValidationLength;
import org.iplass.mtp.impl.validation.MetaValidationNotNull;
import org.iplass.mtp.impl.validation.MetaValidationRange;
import org.iplass.mtp.impl.validation.MetaValidationRegex;
import org.iplass.mtp.impl.validation.MetaValidationScripting;
import org.iplass.mtp.impl.validation.ValidationHandler;

@XmlSeeAlso(value={MetaValidationNotNull.class, MetaValidationRange.class, MetaValidationLength.class, MetaValidationRegex.class, MetaValidationScripting.class, MetaValidationJavaClass.class, MetaValidationBinarySize.class, MetaValidationBinaryType.class, MetaValidationExists.class})
public abstract class MetaValidation
implements MetaData {
    private static final long serialVersionUID = -5030970640762393766L;
    private String description;
    private String errorMessage;
    private String errorCode;
    private String messageCategory;
    private String messageId;
    private List<MetaLocalizedString> localizedErrorMessageList = new ArrayList<MetaLocalizedString>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMessageCategory() {
        return this.messageCategory;
    }

    public void setMessageCategory(String messageCategory) {
        this.messageCategory = messageCategory;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public List<MetaLocalizedString> getLocalizedErrorMessageList() {
        return this.localizedErrorMessageList;
    }

    public void setLocalizedErrorMessageList(List<MetaLocalizedString> localizedErrorMessageList) {
        this.localizedErrorMessageList = localizedErrorMessageList;
    }

    protected void fillTo(ValidationDefinition definition) {
        definition.setDescription(this.description);
        definition.setErrorMessage(this.errorMessage);
        definition.setErrorCode(this.errorCode);
        definition.setMessageCategory(this.messageCategory);
        definition.setMessageId(this.messageId);
        definition.setLocalizedErrorMessageList(I18nUtil.toDef(this.localizedErrorMessageList));
    }

    protected void fillFrom(ValidationDefinition definition) {
        this.description = definition.getDescription();
        this.errorMessage = definition.getErrorMessage();
        this.errorCode = definition.getErrorCode();
        this.messageCategory = definition.getMessageCategory();
        this.messageId = definition.getMessageId();
        this.localizedErrorMessageList = I18nUtil.toMeta(definition.getLocalizedErrorMessageList());
    }

    public abstract void applyConfig(ValidationDefinition var1);

    public abstract ValidationDefinition currentConfig(EntityContext var1);

    @Override
    public abstract MetaValidation copy();

    public abstract ValidationHandler createRuntime(MetaEntity var1, MetaProperty var2);

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.localizedErrorMessageList == null ? 0 : this.localizedErrorMessageList.hashCode());
        result = 31 * result + (this.messageCategory == null ? 0 : this.messageCategory.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidation other = (MetaValidation)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.errorCode == null ? other.errorCode != null : !this.errorCode.equals(other.errorCode)) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.localizedErrorMessageList == null ? other.localizedErrorMessageList != null : !this.localizedErrorMessageList.equals(other.localizedErrorMessageList)) {
            return false;
        }
        if (this.messageCategory == null ? other.messageCategory != null : !this.messageCategory.equals(other.messageCategory)) {
            return false;
        }
        return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
    }
}

