/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.validations.ExistsValidation;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;
import org.iplass.mtp.util.StringUtil;

public class MetaValidationExists
extends MetaValidation {
    private static final long serialVersionUID = -2810049312153732045L;
    private static final String VERSION_TYPE_CONTEXT = "versionType";
    private static final String ERROR_DATA_CONTEXT = "errorDatas";
    private static final String REFERENCE_BIND_NAME = "${reference}";
    private static final Pattern valuePattern = Pattern.compile("${reference}", 16);

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
    }

    @Override
    public ValidationDefinition currentConfig(EntityContext context) {
        ExistsValidation def = new ExistsValidation();
        this.fillTo(def);
        return def;
    }

    @Override
    public MetaValidationExists copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, final MetaProperty property) {
        return new ValidationHandler(this){

            @Override
            public boolean validate(Object value, ValidationContext context) {
                if (value == null) {
                    return true;
                }
                if (value instanceof Entity) {
                    return this.checkExists((Entity)value, context);
                }
                throw new EntityRuntimeException("not support type:" + value.getClass());
            }

            @Override
            public boolean validateArray(Object[] values, ValidationContext context) {
                boolean res = true;
                if (values != null) {
                    for (Object v : values) {
                        res &= this.validate(v, context);
                    }
                }
                return res;
            }

            @Override
            public String generateErrorMessage(Object value, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
                List errors;
                String msg = super.generateErrorMessage(value, context, propertyDisplayName, entityDisplayName);
                if (msg != null && msg.contains(MetaValidationExists.REFERENCE_BIND_NAME) && (errors = (List)context.getAttribute(MetaValidationExists.ERROR_DATA_CONTEXT)) != null) {
                    StringBuilder strValue = new StringBuilder();
                    for (int i = 0; i < errors.size(); ++i) {
                        Entity entity = (Entity)errors.get(i);
                        if (i != 0) {
                            strValue.append(", ");
                        }
                        strValue.append(entity.getOid());
                        if (context.getAttribute(MetaValidationExists.VERSION_TYPE_CONTEXT) != VersionControlType.VERSIONED) continue;
                        strValue.append("." + (entity.getVersion() != null ? entity.getVersion() : "0"));
                    }
                    msg = valuePattern.matcher(msg).replaceAll(strValue.toString());
                }
                return msg;
            }

            private boolean checkExists(Entity entity, ValidationContext context) {
                MetaReferenceProperty rp = (MetaReferenceProperty)property;
                if (StringUtil.isNotEmpty(rp.getMappedByPropertyMetaDataId())) {
                    return true;
                }
                EntityContext ectx = EntityContext.getCurrentContext();
                EntityHandler refEntity = ectx.getHandlerById(rp.getReferenceEntityMetaDataId());
                if (refEntity != null) {
                    VersionControlType versionType = refEntity.getMetaData().getVersionControlType();
                    context.setAttribute(MetaValidationExists.VERSION_TYPE_CONTEXT, (Object)versionType);
                    Query query = new Query().select("oid").from(refEntity.getMetaData().getName());
                    Condition condition = null;
                    condition = versionType == VersionControlType.VERSIONED ? new And().eq("oid", entity.getOid()).eq("version", entity.getVersion() != null ? entity.getVersion() : 0L) : new Equals("oid", entity.getOid());
                    query.where(condition);
                    EntityManager em = ManagerLocator.manager(EntityManager.class);
                    if (em.count(query) <= 0) {
                        ArrayList<Entity> errors = (ArrayList<Entity>)context.getAttribute(MetaValidationExists.ERROR_DATA_CONTEXT);
                        if (errors == null) {
                            errors = new ArrayList<Entity>();
                            context.setAttribute(MetaValidationExists.ERROR_DATA_CONTEXT, errors);
                        }
                        errors.add(entity);
                        return false;
                    }
                    return true;
                }
                return true;
            }
        };
    }
}

