/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.List;
import java.util.regex.Pattern;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.message.MessageService;
import org.iplass.mtp.impl.message.MetaMessageCategory;
import org.iplass.mtp.impl.message.MetaMessageItem;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.spi.ServiceRegistry;

public abstract class ValidationHandler {
    static final Pattern namePattern = Pattern.compile("${name}", 16);
    static final Pattern entityNamePattern = Pattern.compile("${entityName}", 16);
    protected MetaValidation metaData;

    public ValidationHandler(MetaValidation metaData) {
        this.metaData = metaData;
        this.init();
    }

    public String getErrorMessage() {
        return this.metaData.getErrorMessage();
    }

    public void init() {
    }

    public abstract boolean validate(Object var1, ValidationContext var2);

    public boolean validateArray(Object[] values, ValidationContext context) {
        boolean res = true;
        if (values != null) {
            for (Object v : values) {
                if (!(res &= this.validate(v, context))) break;
            }
        }
        return res;
    }

    public String generateErrorMessage(Object value, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
        MetaMessageItem mmi;
        MessageService ms;
        MetaMessageCategory.MetaMessageCategoryHandler mmc;
        String msg = this.getErrorMessage();
        List<MetaLocalizedString> localizedMsg = this.metaData.getLocalizedErrorMessageList();
        if ((msg == null || msg.length() == 0) && this.metaData.getMessageCategory() != null && this.metaData.getMessageId() != null && (mmc = (MetaMessageCategory.MetaMessageCategoryHandler)(ms = ServiceRegistry.getRegistry().getService(MessageService.class)).getRuntimeByName(this.metaData.getMessageCategory())) != null && (mmi = mmc.getMetaData().getMessages().get(this.metaData.getMessageId())) != null) {
            msg = mmi.getMessage();
            localizedMsg = mmi.getLocalizedMessageList();
        }
        if ((msg = I18nUtil.stringMeta(msg, localizedMsg)) != null) {
            if (msg.contains("${name}")) {
                msg = namePattern.matcher(msg).replaceAll(propertyDisplayName);
            }
            if (msg.contains("${entityName}")) {
                msg = entityNamePattern.matcher(msg).replaceAll(entityDisplayName);
            }
        }
        return msg;
    }

    public String getErrorCode() {
        String code = this.metaData.getErrorCode();
        if (code == null) {
            return "";
        }
        return code;
    }
}

