/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation.bean;

import java.util.Locale;
import java.util.Map;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.iplass.mtp.impl.core.ExecuteContext;

public class BeanValidationConfig {
    private Class providerClass;
    private MessageInterpolator messageInterpolator;
    private Map<String, String> properties;

    public Class<?> getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(Class<?> providerClass) {
        this.providerClass = providerClass;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public ValidatorFactory getValidatorFactory() {
        Configuration config = this.providerClass != null ? Validation.byProvider((Class)this.providerClass).configure() : Validation.byDefaultProvider().configure();
        if (this.messageInterpolator != null) {
            config.messageInterpolator((MessageInterpolator)new TenantLocaleMessageInterpolator(this.messageInterpolator));
        } else {
            config.messageInterpolator((MessageInterpolator)new TenantLocaleMessageInterpolator(config.getDefaultMessageInterpolator()));
        }
        if (this.properties != null) {
            this.properties.forEach((name, value) -> config.addProperty(name, value));
        }
        return config.buildValidatorFactory();
    }

    private static class TenantLocaleMessageInterpolator
    implements MessageInterpolator {
        private MessageInterpolator wrapped;

        private TenantLocaleMessageInterpolator(MessageInterpolator wrapped) {
            this.wrapped = wrapped;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            return this.wrapped.interpolate(messageTemplate, context, ExecuteContext.getCurrentContext().getLangLocale());
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            return this.wrapped.interpolate(messageTemplate, context, locale);
        }
    }
}

