/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.filter;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.filter.MetaEntityFilterItem;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterItem;

@XmlRootElement
public class MetaEntityFilter
extends BaseRootMetaData
implements DefinableMetaData<EntityFilter> {
    private static final long serialVersionUID = -2468076736719316702L;
    private String definitionId;
    private List<MetaEntityFilterItem> items;

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public List<MetaEntityFilterItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<MetaEntityFilterItem>();
        }
        return this.items;
    }

    public void setItems(List<MetaEntityFilterItem> items) {
        this.items = items;
    }

    public void addItem(MetaEntityFilterItem item) {
        this.getItems().add(item);
    }

    @Override
    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new EntityFilterHandler();
    }

    @Override
    public MetaEntityFilter copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(EntityFilter filter) {
        if (this.id == null) {
            this.id = new KeyGenerator().generateId();
        }
        EntityContext metaContext = EntityContext.getCurrentContext();
        MetaEntity metaEntity = metaContext.getHandlerByName(filter.getDefinitionName()).getMetaData();
        this.name = filter.getName();
        this.displayName = filter.getDisplayName();
        this.description = filter.getDescription();
        this.definitionId = metaEntity.getId();
        for (EntityFilterItem item : filter.getItems()) {
            MetaEntityFilterItem mItem = new MetaEntityFilterItem();
            mItem.applyConfig(item);
            this.addItem(mItem);
        }
    }

    @Override
    public EntityFilter currentConfig() {
        EntityContext metaContext = EntityContext.getCurrentContext();
        MetaEntity metaEntity = metaContext.getHandlerById(this.definitionId).getMetaData();
        EntityFilter filter = new EntityFilter();
        filter.setName(this.name);
        filter.setDisplayName(this.displayName);
        filter.setDescription(this.description);
        filter.setDefinitionName(metaEntity.getName());
        for (MetaEntityFilterItem mItem : this.getItems()) {
            filter.addItem(mItem.currentConfig());
        }
        return filter;
    }

    public class EntityFilterHandler
    extends BaseMetaDataRuntime {
        @Override
        public MetaEntityFilter getMetaData() {
            return MetaEntityFilter.this;
        }
    }
}

