/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook;

import org.iplass.mtp.webhook.WebhookException;
import org.iplass.mtp.webhook.WebhookHeader;
import org.iplass.mtp.webhook.WebhookResponse;
import org.iplass.mtp.webhook.WebhookResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebhookResponseHandler
implements WebhookResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(DefaultWebhookResponseHandler.class);

    @Override
    public void handleResponse(WebhookResponse response) {
        if (200 > response.getStatusCode() || response.getStatusCode() >= 300) {
            throw new WebhookException("UnHandled Response Status Code: " + response.getStatusCode() + "(" + response.getReasonPhrase() + ")");
        }
        this.writeLog(response);
    }

    private void writeLog(WebhookResponse response) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            this.makeStatusString(response, msg);
            this.makeHeaderString(response, msg);
            this.makeEntityString(response, msg);
            logger.debug(msg.toString());
        }
    }

    private void makeStatusString(WebhookResponse whr, StringBuilder msg) {
        msg.append("Response Code ");
        msg.append(whr.getStatusCode());
        msg.append(":");
        msg.append(whr.getReasonPhrase());
        msg.append(";");
    }

    private void makeHeaderString(WebhookResponse response, StringBuilder msg) {
        msg.append("Headers: ");
        if (response.getHeaders() == null) {
            msg.append("null;");
        } else {
            for (WebhookHeader hd : response.getHeaders()) {
                msg.append(hd.getKey());
                msg.append(":");
                msg.append(hd.getValue());
                msg.append("|");
            }
            msg.substring(0, msg.length() - 1);
            msg.append(";");
        }
    }

    private void makeEntityString(WebhookResponse whr, StringBuilder msg) {
        if (whr.getResponseBody() == null) {
            msg.append("Entity(null);");
        } else {
            msg.append("Entity(");
            msg.append(whr.getContentType() == null ? "nullTypeName" : whr.getContentType());
            msg.append(":");
            msg.append(whr.getContentEncoding() == null ? "nullEncodeName" : whr.getContentEncoding());
            msg.append("):");
            msg.append(whr.getResponseBody());
        }
        msg.append(";");
    }
}

