/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook;

import java.io.Serializable;
import java.sql.Timestamp;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.webhook.WebhookAuthTokenInfo;

public class WebhookAuthTokenHandler
extends AuthTokenHandler {
    public static final String BASIC_AUTHENTICATION_TYPE = "WHBA";
    public static final String BEARER_AUTHENTICATION_TYPE = "WHBT";
    public static final String HMAC_AUTHENTICATION_TYPE = "WHHM";
    public static final String CUSTOM_AUTHENTICATION_TYPE = "WHCT";
    public static final String TYPE_WEBHOOK_AUTHTOKEN_HANDLER = "WEBHOOKATH";

    @Override
    public AuthTokenInfo toAuthTokenInfo(AuthToken authToken) {
        WebhookAuthTokenInfo info = new WebhookAuthTokenInfo();
        info.setType(authToken.getType());
        info.setKey(authToken.getSeries());
        info.setStartDate(authToken.getStartDate());
        return info;
    }

    public String getSecret(int tenantId, String series, String type) {
        this.checkTypeValidity(type);
        AuthToken token = this.authTokenStore().getBySeries(tenantId, type, series);
        if (token == null) {
            return null;
        }
        return token.getToken();
    }

    public void insertSecret(int tenantId, String type, String metaDataId, String series, String tokenSecret) {
        this.checkTypeValidity(type);
        Timestamp startDate = new Timestamp(System.currentTimeMillis());
        AuthToken token = new AuthToken(tenantId, type, metaDataId, series, tokenSecret, "", startDate, null);
        this.authTokenStore().create(token);
    }

    public void updateSecret(int tenantId, String typeCode, String metaDataId, String series, String tokenSecret) {
        this.checkTypeValidity(typeCode);
        AuthToken oldToken = this.authTokenStore().getBySeries(tenantId, typeCode, series);
        Timestamp startDate = new Timestamp(System.currentTimeMillis());
        AuthToken newToken = new AuthToken(tenantId, typeCode, metaDataId, series, tokenSecret, "", startDate, null);
        this.authTokenStore().update(newToken, oldToken);
    }

    public void deleteSecret(int tenantId, String typeCode, String series) {
        this.checkTypeValidity(typeCode);
        this.authTokenStore().deleteBySeries(tenantId, typeCode, series);
    }

    @Override
    public Credential toCredential(AuthToken newToken) {
        return null;
    }

    @Override
    protected Serializable createDetails(String seriesString, String tokenString, String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        return null;
    }

    private boolean checkTypeValidity(String typeCode) {
        if (BASIC_AUTHENTICATION_TYPE.equals(typeCode)) {
            return true;
        }
        if (BEARER_AUTHENTICATION_TYPE.equals(typeCode)) {
            return true;
        }
        if (HMAC_AUTHENTICATION_TYPE.equals(typeCode)) {
            return true;
        }
        if (CUSTOM_AUTHENTICATION_TYPE.equals(typeCode)) {
            return true;
        }
        throw new RuntimeException("The type is not an acceptable WebhookAuthToken Type");
    }
}

