/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.async.AsyncTaskManager;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.impl.webhook.DefaultWebhookResponseHandler;
import org.iplass.mtp.impl.webhook.WebhookService;
import org.iplass.mtp.impl.webhook.endpoint.MetaWebhookEndpoint;
import org.iplass.mtp.impl.webhook.endpoint.WebhookEndpointService;
import org.iplass.mtp.impl.webhook.template.MetaWebhookTemplate;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webhook.Webhook;
import org.iplass.mtp.webhook.WebhookHeader;
import org.iplass.mtp.webhook.WebhookResponse;
import org.iplass.mtp.webhook.endpoint.WebhookAuthenticationType;
import org.iplass.mtp.webhook.template.definition.WebhookTemplateDefinition;
import org.iplass.mtp.webhook.template.definition.WebhookTemplateDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookServiceImpl
extends AbstractTypedMetaDataService<MetaWebhookTemplate, MetaWebhookTemplate.WebhookTemplateRuntime>
implements WebhookService {
    public static final String WEBHOOK_TEMPLATE_META_PATH = "/webhook/template/";
    private static final String WEBHOOK_ISRETRY = "retry";
    private static final String WEBHOOK_RETRY_MAXIMUMATTEMPTS = "retryMaximumAttempts";
    private static final String WEBHOOK_RETRY_INTERVAL = "retryInterval";
    private static final String WEBHOOK_HMACTOKEN_ALGORITHM = "hmacHashAlgorithm";
    private static final String WEBHOOK_HMACTOKEN_DEFAULTNAME = "hmacTokenDefaultName";
    private static final String WEBHOOK_HTTP_CLIENT_CONFIG = "httpClientConfig";
    private static final String WEBHOOK_DEFAULT_HMACALGORITHM = "HmacSHA256";
    private static final String WEBHOOK_HMAC_TOKEN_DEFAULT_NAME = "X-IPLASS-HMAC";
    private static Logger logger = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private AsyncTaskManager atm;
    private WebhookEndpointService wheps;
    private boolean webhookIsRetry;
    private int webhookRetryMaximumAttpempts;
    private int webhookRetryInterval;
    private String webhookHmacHashAlgorithm;
    private String webhookHmacTokenDefaultName;
    private HttpClientConfig webhookHttpClientConfig;
    private CloseableHttpClient webhookHttpClient;

    public static String getFixedPath() {
        return WEBHOOK_TEMPLATE_META_PATH;
    }

    @Override
    public void init(Config config) {
        this.webhookHttpClientConfig = new HttpClientConfig();
        Iterator<String> iterator = config.getNames().iterator();
        while (iterator.hasNext()) {
            String name;
            switch (name = iterator.next()) {
                case "retry": {
                    String tempIsRetry = config.getValue(WEBHOOK_ISRETRY);
                    if ("true".equals(tempIsRetry.replaceAll("\\s", "").toLowerCase())) {
                        this.webhookIsRetry = true;
                        break;
                    }
                    this.webhookIsRetry = false;
                    break;
                }
                case "retryMaximumAttempts": {
                    this.webhookRetryMaximumAttpempts = Integer.valueOf(config.getValue(WEBHOOK_RETRY_MAXIMUMATTEMPTS));
                    break;
                }
                case "retryInterval": {
                    this.webhookRetryInterval = Integer.valueOf(config.getValue(WEBHOOK_RETRY_INTERVAL));
                    break;
                }
                case "hmacHashAlgorithm": {
                    this.webhookHmacHashAlgorithm = config.getValue(WEBHOOK_HMACTOKEN_ALGORITHM);
                    if (this.webhookHmacHashAlgorithm != null && !this.webhookHmacHashAlgorithm.replaceAll("\\s", "").isEmpty()) break;
                    this.webhookHmacHashAlgorithm = WEBHOOK_DEFAULT_HMACALGORITHM;
                    break;
                }
                case "hmacTokenDefaultName": {
                    this.webhookHmacTokenDefaultName = config.getValue(WEBHOOK_HMACTOKEN_DEFAULTNAME);
                    if (this.webhookHmacTokenDefaultName != null && !this.webhookHmacTokenDefaultName.replaceAll("\\s", "").isEmpty()) break;
                    this.webhookHmacTokenDefaultName = WEBHOOK_HMAC_TOKEN_DEFAULT_NAME;
                    break;
                }
                case "httpClientConfig": {
                    this.webhookHttpClientConfig = config.getValue(WEBHOOK_HTTP_CLIENT_CONFIG, HttpClientConfig.class);
                    if (this.webhookHttpClientConfig != null) break;
                    this.webhookHttpClientConfig = new HttpClientConfig();
                }
            }
        }
        this.webhookHttpClientConfig.inited(this, config);
        this.atm = ManagerLocator.getInstance().getManager(AsyncTaskManager.class);
        this.wheps = ServiceRegistry.getRegistry().getService(WebhookEndpointService.class);
        this.initWebhookHttpClient();
    }

    private void initWebhookHttpClient() {
        if (this.webhookHttpClient == null) {
            this.webhookHttpClient = this.webhookHttpClientConfig.getInstance();
        }
    }

    @Override
    public void destroy() {
        try {
            this.webhookHttpClient.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    public Class<MetaWebhookTemplate> getMetaDataType() {
        return MetaWebhookTemplate.class;
    }

    @Override
    public Class<MetaWebhookTemplate.WebhookTemplateRuntime> getRuntimeType() {
        return MetaWebhookTemplate.WebhookTemplateRuntime.class;
    }

    @Override
    public Webhook getWebhookByName(String webhookDefinitionName, Map<String, Object> binding) {
        MetaWebhookTemplate.WebhookTemplateRuntime webhookRuntime = (MetaWebhookTemplate.WebhookTemplateRuntime)this.getRuntimeByName(webhookDefinitionName);
        Webhook webhook = webhookRuntime.createWebhook(binding);
        return webhook;
    }

    @Override
    public void sendWebhookSync(Webhook webhook) {
        this.sendWebhook(webhook);
    }

    @Override
    public void sendWebhookAsync(Webhook webhook) {
        this.atm.executeOnThread(new WebhookCallable(webhook));
    }

    @Override
    public Webhook generateWebhook(String webhookDefinitionName, Map<String, Object> binding, String endpointDefinitionName) {
        MetaWebhookTemplate.WebhookTemplateRuntime webhookRuntime = (MetaWebhookTemplate.WebhookTemplateRuntime)this.getRuntimeByName(webhookDefinitionName);
        MetaWebhookEndpoint.WebhookEndpointRuntime endpointRuntime = (MetaWebhookEndpoint.WebhookEndpointRuntime)this.wheps.getRuntimeByName(endpointDefinitionName);
        if (endpointRuntime == null) {
            throw new SystemException("Endpoint Template:" + endpointDefinitionName + " not found");
        }
        if (webhookRuntime == null) {
            throw new SystemException("WebhookTemplate:" + webhookDefinitionName + " not found");
        }
        Webhook webhook = webhookRuntime.createWebhook(binding);
        webhook.setEndpoint(endpointRuntime.createWebhookEndpoint(binding));
        return webhook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWebhook(Webhook webhook) {
        try {
            HttpRequestBase httpRequest;
            if (webhook.getHttpMethod() == null && logger.isDebugEnabled()) {
                logger.debug("Webhook: request method undefined. Post will be used.");
            }
            if (this.isEnclosingRequest(httpRequest = this.getReqestMethodObject(webhook.getHttpMethod()))) {
                if (webhook.getPayloadContent() != null && !webhook.getPayloadContent().replaceAll("\\s", "").isEmpty()) {
                    StringEntity se = new StringEntity(webhook.getPayloadContent(), "UTF-8");
                    se.setContentType(webhook.getContentType());
                    ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)se);
                }
            } else if (webhook.getContentType() != null && !webhook.getContentType().replaceAll("\\s", "").isEmpty()) {
                httpRequest.setHeader("Content-Type", webhook.getContentType());
            }
            if (webhook.getHeaders() != null) {
                for (WebhookHeader headerEntry : webhook.getHeaders()) {
                    httpRequest.setHeader(headerEntry.getKey(), headerEntry.getValue());
                }
            }
            if (webhook.getEndpoint() != null) {
                if (webhook.getEndpoint().getHmacKey() != null && !webhook.getEndpoint().getHmacKey().isEmpty()) {
                    String hmacHeader = webhook.getEndpoint().getHmacHashHeader() == null || webhook.getEndpoint().getHmacHashHeader().replaceAll("\\s", "").isEmpty() ? this.webhookHmacTokenDefaultName : webhook.getEndpoint().getHmacHashHeader().replaceAll("\\s", "");
                    httpRequest.setHeader(hmacHeader, this.getHmacSha256(webhook.getEndpoint().getHmacKey(), webhook.getPayloadContent()));
                }
                if (webhook.getEndpoint().getHeaderAuthorizationType() != null) {
                    String scheme = "";
                    String authContent = "";
                    if (WebhookAuthenticationType.BEARER.equals((Object)webhook.getEndpoint().getHeaderAuthorizationType())) {
                        scheme = "Bearer";
                        authContent = webhook.getEndpoint().getHeaderAuthorizationContent();
                    } else if (WebhookAuthenticationType.BASIC.equals((Object)webhook.getEndpoint().getHeaderAuthorizationType())) {
                        scheme = "Basic";
                        if (webhook.getEndpoint().getHeaderAuthorizationContent() != null && !webhook.getEndpoint().getHeaderAuthorizationContent().replaceAll("\\s+", "").isEmpty()) {
                            authContent = Base64.encodeBase64String((byte[])webhook.getEndpoint().getHeaderAuthorizationContent().getBytes());
                        }
                    } else if (WebhookAuthenticationType.CUSTOM.equals((Object)webhook.getEndpoint().getHeaderAuthorizationType())) {
                        String authTypeName;
                        scheme = "Custom";
                        if (webhook.getEndpoint().getHeaderAuthCustomTypeName() != null && !(authTypeName = webhook.getEndpoint().getHeaderAuthCustomTypeName().replace("\n", "").replaceAll("\\s+", "")).isEmpty()) {
                            scheme = authTypeName;
                        }
                        authContent = webhook.getEndpoint().getHeaderAuthorizationContent();
                    }
                    if (authContent != null && !authContent.replaceAll("\\s+", "").isEmpty()) {
                        httpRequest.setHeader("Authorization", scheme + " " + authContent);
                    }
                }
            }
            String url = webhook.getEndpoint().getUrl() + webhook.getPathAndQuery();
            httpRequest.setURI(new URI(url));
            CloseableHttpResponse response = null;
            if (this.webhookIsRetry) {
                for (int i = 0; i < this.webhookRetryMaximumAttpempts; ++i) {
                    try {
                        response = this.webhookHttpClient.execute((HttpUriRequest)httpRequest);
                        break;
                    }
                    catch (Exception e) {
                        if (e.getClass() == InterruptedIOException.class || e.getClass() == UnknownHostException.class || e.getClass() == ConnectException.class || e.getClass() == SSLException.class) {
                            logger.info("Webhook:" + e.getClass().getName() + " has occured. Stop retrying.");
                            break;
                        }
                        try {
                            Thread.sleep(this.webhookRetryInterval);
                            continue;
                        }
                        catch (InterruptedException exception) {
                            logger.warn("An Webhook retry interval is interrupted, stop retrying.");
                            break;
                        }
                    }
                }
            } else {
                response = this.webhookHttpClient.execute((HttpUriRequest)httpRequest);
            }
            try {
                if (response != null) {
                    WebhookResponse whr = this.generateWebhookResponse((HttpResponse)response);
                    if (webhook.getResponseHandler() == null) {
                        webhook.setResponseHandler(new DefaultWebhookResponseHandler());
                    }
                    webhook.getResponseHandler().handleResponse(whr);
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String getHmacSha256(String secret, String message) {
        try {
            Mac Hmac = Mac.getInstance(this.webhookHmacHashAlgorithm);
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes("UTF-8"), this.webhookHmacHashAlgorithm);
            Hmac.init(secret_key);
            String hash = Base64.encodeBase64String((byte[])Hmac.doFinal(message.getBytes("UTF-8")));
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private HttpRequestBase getReqestMethodObject(String methodName) {
        if (methodName.equals("GET")) {
            return new HttpGet();
        }
        if (methodName.equals("POST")) {
            return new HttpPost();
        }
        if (methodName.equals("DELETE")) {
            return new HttpDelete();
        }
        if (methodName.equals("PUT")) {
            return new HttpPut();
        }
        if (methodName.equals("PATCH")) {
            return new HttpPatch();
        }
        return new HttpPost();
    }

    private boolean isEnclosingRequest(HttpRequestBase request) {
        return request.getMethod().equals("PATCH") || request.getMethod().equals("POST") || request.getMethod().equals("PUT");
    }

    private WebhookResponse generateWebhookResponse(HttpResponse response) {
        WebhookResponse whr = new WebhookResponse();
        if (response.getStatusLine() == null) {
            whr.setStatusCode(0);
            whr.setReasonPhrase(null);
        } else {
            whr.setStatusCode(response.getStatusLine().getStatusCode());
            whr.setReasonPhrase(response.getStatusLine().getReasonPhrase());
        }
        if (response.getEntity() == null) {
            whr.setContentType(null);
            whr.setContentEncoding(null);
            whr.setResponseBody(null);
        } else {
            try {
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                whr.setResponseBody(entity);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            whr.setContentType(response.getEntity().getContentType() == null ? null : response.getEntity().getContentType().getValue());
            whr.setContentEncoding(response.getEntity().getContentEncoding() == null ? null : response.getEntity().getContentEncoding().getValue());
        }
        ArrayList<WebhookHeader> headers = new ArrayList<WebhookHeader>();
        if (response.getAllHeaders() != null) {
            for (Header hd : response.getAllHeaders()) {
                headers.add(new WebhookHeader(hd.getName(), hd.getValue()));
            }
        }
        whr.setHeaders(headers);
        return whr;
    }

    private class WebhookCallable
    implements Callable<Void> {
        Webhook webhook;

        public WebhookCallable(Webhook webhook) {
            this.webhook = webhook;
        }

        @Override
        public Void call() throws Exception {
            WebhookServiceImpl.this.sendWebhook(this.webhook);
            return null;
        }
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<WebhookTemplateDefinition, MetaWebhookTemplate> {
        public TypeMap() {
            super(WebhookServiceImpl.getFixedPath(), MetaWebhookTemplate.class, WebhookTemplateDefinition.class);
        }

        @Override
        public TypedDefinitionManager<WebhookTemplateDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(WebhookTemplateDefinitionManager.class);
        }
    }
}

