/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook.endpoint;

import org.iplass.mtp.definition.DefinitionModifyResult;
import org.iplass.mtp.impl.definition.AbstractTypedDefinitionManager;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.webhook.endpoint.MetaWebhookEndpoint;
import org.iplass.mtp.impl.webhook.endpoint.WebhookEndpointService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webhook.endpoint.definition.WebhookEndpointDefinition;
import org.iplass.mtp.webhook.endpoint.definition.WebhookEndpointDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookEndpointDefinitionManagerImpl
extends AbstractTypedDefinitionManager<WebhookEndpointDefinition>
implements WebhookEndpointDefinitionManager {
    private static final Logger logger = LoggerFactory.getLogger(WebhookEndpointDefinitionManager.class);
    private WebhookEndpointService service = ServiceRegistry.getRegistry().getService(WebhookEndpointService.class);

    @Override
    public Class<WebhookEndpointDefinition> getDefinitionType() {
        return WebhookEndpointDefinition.class;
    }

    @Override
    public DefinitionModifyResult remove(String definitionName) {
        WebhookEndpointDefinition definition = (WebhookEndpointDefinition)super.get(definitionName);
        WebhookEndpointService weps = (WebhookEndpointService)this.getService();
        try {
            weps.deleteSecurityTokenByDefinitionName(definition.getName());
        }
        catch (Exception e) {
            logger.warn("Exception occured while removing the data from Database for :" + definitionName + ". Caused by: " + e.getCause() + ". With following message : " + e.getCause().getMessage());
            throw (RuntimeException)e;
        }
        return super.remove(definitionName);
    }

    @Override
    public void modifySecurityToken(int tenantId, String definitionName, String secret, String tokenType) {
        if (tokenType == null) {
            throw new RuntimeException("null TokenType");
        }
        if ("WHHM".equals(tokenType)) {
            this.service.updateHmacSecurityTokenByDefinitionName(tenantId, definitionName, secret);
        }
        if ("WHBT".equals(tokenType)) {
            this.service.updateBearerSecurityTokenByDefinitionName(tenantId, definitionName, secret);
        }
        if ("WHBA".equals(tokenType)) {
            this.service.updateBasicSecurityTokenByDefinitionName(tenantId, definitionName, secret);
        }
        if ("WHCT".equals(tokenType)) {
            this.service.updateCustomSecurityTokenByDefinitionName(tenantId, definitionName, secret);
        }
    }

    @Override
    public String generateHmacKey() {
        return this.service.generateHmacTokenString();
    }

    @Override
    protected RootMetaData newInstance(WebhookEndpointDefinition definition) {
        return new MetaWebhookEndpoint();
    }

    @Override
    protected TypedMetaDataService getService() {
        return this.service;
    }
}

