/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.impl.mail.BinaryReferenceDataSource;
import org.iplass.mtp.mail.HtmlMessage;
import org.iplass.mtp.mail.MailException;

public class Mail {
    private List<InternetAddress> recipientTo = new ArrayList<InternetAddress>();
    private List<InternetAddress> recipientCc = new ArrayList<InternetAddress>();
    private List<InternetAddress> recipientBcc = new ArrayList<InternetAddress>();
    private InternetAddress fromAddress;
    private InternetAddress replyToAddress;
    private String returnPath;
    private final String charset;
    private String subject;
    private String message;
    private HtmlMessage htmlMessage;
    private Date date;
    private List<DataHandler> attachments;
    private boolean smimeSign;
    private String smimeSignPassword;
    private boolean smimeEncript;

    public Mail(String charset) {
        this.charset = charset;
    }

    public void addRecipientTo(String address) throws MailException {
        this.add(this.recipientTo, address, null);
    }

    public void addRecipientTo(String address, String personal) throws MailException {
        this.add(this.recipientTo, address, personal);
    }

    public void addRecipientCc(String address) throws MailException {
        this.add(this.recipientCc, address, null);
    }

    public void addRecipientCc(String address, String personal) throws MailException {
        this.add(this.recipientCc, address, personal);
    }

    public void addRecipientBcc(String address) throws MailException {
        this.add(this.recipientBcc, address, null);
    }

    public void addRecipientBcc(String address, String personal) throws MailException {
        this.add(this.recipientBcc, address, personal);
    }

    public void setFrom(String address) throws MailException {
        this.setFrom(address, null);
    }

    public void setFrom(String address, String personal) throws MailException {
        this.fromAddress = this.createAddress(address, personal, this.charset);
    }

    public void setFromAddress(InternetAddress address) {
        this.fromAddress = address;
    }

    private InternetAddress createAddress(String address, String personal, String charset) {
        try {
            InternetAddress iAddress = personal == null ? new InternetAddress(address) : new InternetAddress(address, personal, charset);
            iAddress.validate();
            return iAddress;
        }
        catch (AddressException e) {
            throw new MailException("invalid address:" + address, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MailException("invalid charset:" + charset, e);
        }
    }

    private void add(List<InternetAddress> list, String address, String personal) throws MailException {
        list.add(this.createAddress(address, personal, this.charset));
    }

    public InternetAddress getFromAddress() {
        return this.fromAddress;
    }

    public void setReplyTo(String address) throws MailException {
        this.setReplyTo(address, null);
    }

    public void setReplyTo(String address, String personal) throws MailException {
        this.replyToAddress = this.createAddress(address, personal, this.charset);
    }

    public void setReplyToAddress(InternetAddress address) {
        this.replyToAddress = address;
    }

    public InternetAddress getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public HtmlMessage getHtmlMessage() {
        return this.htmlMessage;
    }

    public void setHtmlMessage(HtmlMessage htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void addAttachment(BinaryReference bin) {
        this.addAttachment(new DataHandler((DataSource)new BinaryReferenceDataSource(bin)));
    }

    public void addAttachment(DataHandler dataHandler) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<DataHandler>();
        }
        this.attachments.add(dataHandler);
    }

    public List<DataHandler> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<DataHandler> attachments) {
        this.attachments = attachments;
    }

    public List<InternetAddress> getRecipientTo() {
        return this.recipientTo;
    }

    public void setRecipientTo(List<InternetAddress> recipientTo) {
        this.recipientTo = recipientTo;
    }

    public List<InternetAddress> getRecipientCc() {
        return this.recipientCc;
    }

    public void setRecipientCc(List<InternetAddress> recipientCc) {
        this.recipientCc = recipientCc;
    }

    public List<InternetAddress> getRecipientBcc() {
        return this.recipientBcc;
    }

    public void setRecipientBcc(List<InternetAddress> recipientBcc) {
        this.recipientBcc = recipientBcc;
    }

    public void setSmimeSign(boolean smimeSign) {
        this.smimeSign = smimeSign;
    }

    public boolean isSmimeSign() {
        return this.smimeSign;
    }

    public void setSmimeSignPassword(String smimeSignPassword) {
        this.smimeSignPassword = smimeSignPassword;
    }

    public String getSmimeSignPassword() {
        return this.smimeSignPassword;
    }

    public void setSmimeEncript(boolean smimeEncript) {
        this.smimeEncript = smimeEncript;
    }

    public boolean isSmimeEncript() {
        return this.smimeEncript;
    }
}

