/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.mail.listeners;

import java.util.List;
import javax.activation.DataHandler;
import javax.mail.internet.InternetAddress;
import org.iplass.mtp.mail.InlineContent;
import org.iplass.mtp.mail.Mail;
import org.iplass.mtp.mail.SendMailListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSendMailListener
implements SendMailListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingSendMailListener.class);

    @Override
    public boolean beforeSend(Mail mail) {
        this.debugMail(mail);
        return true;
    }

    private void debugMail(Mail mail) {
        if (mail != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("\r\n");
            builder.append(this.debugRecipientAddress("From", mail.getFromAddress()) + "\n");
            builder.append(this.debugRecipientAddress("ReplyTo", mail.getReplyToAddress()) + "\n");
            builder.append(this.debugRecipientAddress("To", mail.getRecipientTo()) + "\n");
            builder.append(this.debugRecipientAddress("Cc", mail.getRecipientCc()) + "\n");
            builder.append(this.debugRecipientAddress("Bcc", mail.getRecipientBcc()) + "\n");
            builder.append("Subject:" + mail.getSubject() + "\n");
            String fileName = "";
            if (mail.getAttachments() != null) {
                for (DataHandler handler : mail.getAttachments()) {
                    fileName = fileName + handler.getName() + " ";
                }
            }
            builder.append("FileName:" + fileName + "\n");
            builder.append("PlainMessage:" + mail.getMessage() + "\n");
            if (mail.getHtmlMessage() != null) {
                builder.append("HtmlMessage:" + mail.getHtmlMessage().getContent() + "\n");
                if (mail.getHtmlMessage().getInlineContents() != null) {
                    builder.append("InlineContents:");
                    for (InlineContent ic : mail.getHtmlMessage().getInlineContents()) {
                        if (ic == null) continue;
                        builder.append(ic.getContentId()).append(", ");
                    }
                    builder.append("\n");
                }
            }
            log.debug(builder.toString());
        }
    }

    private String debugRecipientAddress(String title, InternetAddress address) {
        return title + ":" + this.getAddressString(address);
    }

    private String debugRecipientAddress(String title, List<InternetAddress> addresses) {
        if (addresses != null) {
            StringBuilder builder = new StringBuilder();
            for (InternetAddress address : addresses) {
                builder.append(this.getAddressString(address) + ";");
            }
            return title + ":(" + addresses.size() + ")" + builder.toString();
        }
        return title + ":(0)";
    }

    private String getAddressString(InternetAddress address) {
        if (address == null) {
            return "";
        }
        if (address.getPersonal() != null && !address.getPersonal().isEmpty()) {
            return address.getPersonal() + "[" + address.getAddress() + "]";
        }
        return address.getAddress();
    }
}

