/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.iplass.mtp.impl.core.ExecuteContext;

public class DateUtil {
    public static Timestamp getCurrentTimestamp() {
        return ExecuteContext.getCurrentContext().getCurrentTimestamp();
    }

    public static Date getCurrentDate() {
        return ExecuteContext.getCurrentContext().getCurrentLocalDate();
    }

    public static Time getCurrentTime() {
        return ExecuteContext.getCurrentContext().getCurrentLocalTime();
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern, boolean useTenantTimeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, ExecuteContext.getCurrentContext().getLocale());
        if (useTenantTimeZone) {
            simpleDateFormat.setTimeZone(ExecuteContext.getCurrentContext().getTimeZone());
        }
        return simpleDateFormat;
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern, boolean useTenantTimeZone, boolean useUserLangLocale) {
        Locale l = useUserLangLocale ? ExecuteContext.getCurrentContext().getLangLocale() : ExecuteContext.getCurrentContext().getLocale();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, l);
        if (useTenantTimeZone) {
            simpleDateFormat.setTimeZone(ExecuteContext.getCurrentContext().getTimeZone());
        }
        return simpleDateFormat;
    }

    public static Calendar getCalendar(boolean useTenantTimeZone) {
        Calendar calendar = Calendar.getInstance(ExecuteContext.getCurrentContext().getLocale());
        if (useTenantTimeZone) {
            calendar.setTimeZone(ExecuteContext.getCurrentContext().getTimeZone());
        }
        return calendar;
    }

    public static Calendar getCalendar(Locale locale, boolean useTenantTimeZone) {
        Calendar calendar = Calendar.getInstance(locale);
        if (useTenantTimeZone) {
            calendar.setTimeZone(ExecuteContext.getCurrentContext().getTimeZone());
        }
        return calendar;
    }

    public static GregorianCalendar getGregorianCalendar(boolean useTenantTimeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(ExecuteContext.getCurrentContext().getLocale());
        if (useTenantTimeZone) {
            gregorianCalendar.setTimeZone(ExecuteContext.getCurrentContext().getTimeZone());
        }
        return gregorianCalendar;
    }

    public static DateFormat getDateInstance(int style, boolean useTenantTimeZone) {
        return DateUtil.getDateInstance(style, null, useTenantTimeZone);
    }

    public static DateFormat getDateInstance(int style, Locale locale, boolean useTenantTimeZone) {
        if (locale == null) {
            locale = ExecuteContext.getCurrentContext().getLocale();
        }
        DateFormat dateFormat = DateFormat.getDateInstance(style, locale);
        if (useTenantTimeZone) {
            dateFormat.setTimeZone(ExecuteContext.getCurrentContext().getTimeZone());
        }
        return dateFormat;
    }

    public static DateFormat getDateTimeInstance(int dateStyle, int timeStyle, boolean useTenantTimeZone) {
        return DateUtil.getDateTimeInstance(dateStyle, timeStyle, null, null, useTenantTimeZone);
    }

    public static DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale, boolean useTenantTimeZone) {
        return DateUtil.getDateTimeInstance(dateStyle, timeStyle, locale, null, useTenantTimeZone);
    }

    public static DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale, TimeZone timeZone, boolean useTenantTimeZone) {
        if (locale == null) {
            locale = ExecuteContext.getCurrentContext().getLocale();
        }
        if (timeZone == null) {
            timeZone = ExecuteContext.getCurrentContext().getTimeZone();
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        if (useTenantTimeZone) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public static DateFormat getTimeInstance(boolean useTenantTimeZone) {
        return DateUtil.getTimeInstance(2, null, useTenantTimeZone);
    }

    public static DateFormat getTimeInstance(int style, boolean useTenantTimeZone) {
        return DateUtil.getTimeInstance(style, null, useTenantTimeZone);
    }

    public static DateFormat getTimeInstance(int style, Locale locale, boolean useTenantTimeZone) {
        if (locale == null) {
            locale = ExecuteContext.getCurrentContext().getLocale();
        }
        DateFormat dateFormat = DateFormat.getTimeInstance(style, locale);
        if (useTenantTimeZone) {
            dateFormat.setTimeZone(ExecuteContext.getCurrentContext().getTimeZone());
        }
        return dateFormat;
    }
}

