/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.filter.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.filter.expression.UnsupportedFilterOperationException;

public class FilterExpressionParser {
    private String expression;
    private FilterItemHandler itemHandler;

    public FilterExpressionParser(String expression, FilterItemHandler itemHandler) {
        this.expression = expression;
        this.itemHandler = itemHandler;
    }

    public Condition parse() {
        if (StringUtil.isEmpty(this.expression)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = Pattern.compile("\\$\\d+").matcher(this.expression);
        int curIndex = 0;
        while (m.find()) {
            Condition c;
            String numStr = this.expression.substring(m.start() + 1, m.end());
            int condIndex = Integer.parseInt(numStr) - 1;
            if (curIndex < m.start()) {
                sb.append(this.expression.substring(curIndex, m.start()));
            }
            if (condIndex >= 0 && !this.itemHandler.isIndexOutOfBounds(condIndex)) {
                c = this.itemHandler.getCondition(condIndex);
                if (c == null) {
                    throw new UnsupportedFilterOperationException(FilterExpressionParser.resourceString("view.filter.nullValueErr", "$" + numStr));
                }
            } else {
                throw new UnsupportedFilterOperationException(FilterExpressionParser.resourceString("view.filter.numberNotFoundErr", "$" + numStr));
            }
            sb.append(c.toString());
            curIndex = m.end();
        }
        if (curIndex < this.expression.length()) {
            sb.append(this.expression.substring(curIndex));
        }
        try {
            return Condition.newCondition(sb.toString());
        }
        catch (QueryException e) {
            throw new UnsupportedFilterOperationException(FilterExpressionParser.resourceString("view.filter.incorrectErr", new Object[0]), e);
        }
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    public static interface FilterItemHandler {
        public boolean isIndexOutOfBounds(int var1);

        public Condition getCondition(int var1);
    }
}

